/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.net.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import znaishaded.io.vertx.core.VertxException;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.impl.VertxInternal;
import znaishaded.io.vertx.core.net.JksOptions;
import znaishaded.io.vertx.core.net.KeyCertOptions;
import znaishaded.io.vertx.core.net.PemKeyCertOptions;
import znaishaded.io.vertx.core.net.PemTrustOptions;
import znaishaded.io.vertx.core.net.PfxOptions;
import znaishaded.io.vertx.core.net.TrustOptions;
import znaishaded.io.vertx.core.net.impl.pkcs1.PrivateKeyParser;

public class KeyStoreHelper {
    private static final String DUMMY_PASSWORD = "dummy";
    private static final String DUMMY_CERT_ALIAS = "cert-";
    private static final Pattern BEGIN_PATTERN = Pattern.compile("-----BEGIN ([A-Z ]+)-----");
    private static final Pattern END_PATTERN = Pattern.compile("-----END ([A-Z ]+)-----");
    private final String password;
    private final KeyStore store;
    private final Map<String, X509KeyManager> wildcardMgrMap = new HashMap<String, X509KeyManager>();
    private final Map<String, X509KeyManager> mgrMap = new HashMap<String, X509KeyManager>();
    private final Map<String, TrustManagerFactory> trustMgrMap = new HashMap<String, TrustManagerFactory>();

    public static KeyStoreHelper create(VertxInternal vertx, KeyCertOptions options) throws Exception {
        if (options instanceof JksOptions) {
            Supplier<Buffer> value;
            JksOptions jks = (JksOptions)options;
            if (jks.getPath() != null) {
                value = () -> vertx.fileSystem().readFileBlocking(vertx.resolveFile(jks.getPath()).getAbsolutePath());
            } else if (jks.getValue() != null) {
                value = jks::getValue;
            } else {
                return null;
            }
            return new KeyStoreHelper(KeyStoreHelper.loadJKSOrPKCS12("JKS", jks.getPassword(), value), jks.getPassword());
        }
        if (options instanceof PfxOptions) {
            Supplier<Buffer> value;
            PfxOptions pkcs12 = (PfxOptions)options;
            if (pkcs12.getPath() != null) {
                value = () -> vertx.fileSystem().readFileBlocking(vertx.resolveFile(pkcs12.getPath()).getAbsolutePath());
            } else if (pkcs12.getValue() != null) {
                value = pkcs12::getValue;
            } else {
                return null;
            }
            return new KeyStoreHelper(KeyStoreHelper.loadJKSOrPKCS12("PKCS12", pkcs12.getPassword(), value), pkcs12.getPassword());
        }
        if (options instanceof PemKeyCertOptions) {
            PemKeyCertOptions keyCert = (PemKeyCertOptions)options;
            ArrayList<Buffer> keys = new ArrayList<Buffer>();
            for (String keyPath : keyCert.getKeyPaths()) {
                keys.add(vertx.fileSystem().readFileBlocking(vertx.resolveFile(keyPath).getAbsolutePath()));
            }
            keys.addAll(keyCert.getKeyValues());
            ArrayList<Buffer> certs = new ArrayList<Buffer>();
            for (String certPath : keyCert.getCertPaths()) {
                certs.add(vertx.fileSystem().readFileBlocking(vertx.resolveFile(certPath).getAbsolutePath()));
            }
            certs.addAll(keyCert.getCertValues());
            return new KeyStoreHelper(KeyStoreHelper.loadKeyCert(keys, certs), DUMMY_PASSWORD);
        }
        return null;
    }

    public static KeyStoreHelper create(VertxInternal vertx, TrustOptions options) throws Exception {
        if (options instanceof KeyCertOptions) {
            return KeyStoreHelper.create(vertx, (KeyCertOptions)((Object)options));
        }
        if (options instanceof PemTrustOptions) {
            PemTrustOptions trustOptions = (PemTrustOptions)options;
            Stream<Buffer> certValues = trustOptions.getCertPaths().stream().map(path2 -> vertx.resolveFile((String)path2).getAbsolutePath()).map(vertx.fileSystem()::readFileBlocking);
            certValues = Stream.concat(certValues, trustOptions.getCertValues().stream());
            return new KeyStoreHelper(KeyStoreHelper.loadCA(certValues), null);
        }
        return null;
    }

    public KeyStoreHelper(KeyStore ks, String password) throws Exception {
        Enumeration<String> en = ks.aliases();
        while (en.hasMoreElements()) {
            String alias = en.nextElement();
            Certificate cert = ks.getCertificate(alias);
            if (ks.isCertificateEntry(alias) && !alias.startsWith(DUMMY_CERT_ALIAS)) {
                KeyStore keyStore = KeyStore.getInstance("jks");
                keyStore.load(null, null);
                keyStore.setCertificateEntry("cert-1", cert);
                TrustManagerFactory fact = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                fact.init(keyStore);
                this.trustMgrMap.put(alias, fact);
            }
            if (!ks.isKeyEntry(alias) || !(cert instanceof X509Certificate)) continue;
            X509Certificate x509Cert = (X509Certificate)cert;
            Collection<List<?>> ans = x509Cert.getSubjectAlternativeNames();
            ArrayList<Object> domains = new ArrayList<Object>();
            if (ans != null) {
                for (List<?> l : ans) {
                    if (l.size() != 2 || !(l.get(0) instanceof Number) || ((Number)l.get(0)).intValue() != 2) continue;
                    String dns = l.get(1).toString();
                    domains.add(dns);
                }
            }
            String dn = x509Cert.getSubjectX500Principal().getName();
            LdapName ldapDN = new LdapName(dn);
            for (Rdn rdn : ldapDN.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("cn")) continue;
                String name = rdn.getValue().toString();
                domains.add(name);
            }
            if (domains.size() <= 0) continue;
            final PrivateKey key = (PrivateKey)ks.getKey(alias, password != null ? password.toCharArray() : null);
            Certificate[] tmp = ks.getCertificateChain(alias);
            if (tmp == null) continue;
            final List chain = Arrays.asList(tmp).stream().map(c -> (X509Certificate)c).collect(Collectors.toList());
            X509KeyManager mgr = new X509KeyManager(){

                @Override
                public String[] getClientAliases(String s2, Principal[] principals) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String[] getServerAliases(String s2, Principal[] principals) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String chooseServerAlias(String s2, Principal[] principals, Socket socket) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public X509Certificate[] getCertificateChain(String s2) {
                    return chain.toArray(new X509Certificate[chain.size()]);
                }

                @Override
                public PrivateKey getPrivateKey(String s2) {
                    return key;
                }
            };
            for (String string : domains) {
                if (string.startsWith("*.")) {
                    this.wildcardMgrMap.put(string.substring(2), mgr);
                    continue;
                }
                this.mgrMap.put(string, mgr);
            }
        }
        this.store = ks;
        this.password = password;
    }

    public KeyManagerFactory getKeyMgrFactory() throws Exception {
        KeyManagerFactory fact = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        fact.init(this.store, this.password != null ? this.password.toCharArray() : null);
        return fact;
    }

    public X509KeyManager getKeyMgr(String serverName) {
        int index;
        X509KeyManager mgr = this.mgrMap.get(serverName);
        if (mgr == null && !this.wildcardMgrMap.isEmpty() && (index = serverName.indexOf(46) + 1) > 0) {
            String s2 = serverName.substring(index);
            mgr = this.wildcardMgrMap.get(s2);
        }
        return mgr;
    }

    public KeyManager[] getKeyMgr() throws Exception {
        return this.getKeyMgrFactory().getKeyManagers();
    }

    public TrustManager[] getTrustMgr(String serverName) {
        TrustManagerFactory fact = this.trustMgrMap.get(serverName);
        return fact != null ? fact.getTrustManagers() : null;
    }

    public TrustManagerFactory getTrustMgrFactory(VertxInternal vertx) throws Exception {
        TrustManagerFactory fact = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        fact.init(this.store);
        return fact;
    }

    public TrustManager[] getTrustMgrs(VertxInternal vertx) throws Exception {
        return this.getTrustMgrFactory(vertx).getTrustManagers();
    }

    public KeyStore store() throws Exception {
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadJKSOrPKCS12(String type, String password, Supplier<Buffer> value) throws Exception {
        KeyStore ks = KeyStore.getInstance(type);
        InputStream in = null;
        try {
            in = new ByteArrayInputStream(value.get().getBytes());
            ks.load(in, password != null ? password.toCharArray() : null);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ks;
    }

    private static KeyStore loadKeyCert(List<Buffer> keyValue, List<Buffer> certValue) throws Exception {
        if (keyValue.size() < certValue.size()) {
            throw new VertxException("Missing private key");
        }
        if (keyValue.size() > certValue.size()) {
            throw new VertxException("Missing X.509 certificate");
        }
        KeyStore keyStore = KeyStore.getInstance("jks");
        keyStore.load(null, null);
        Iterator<Buffer> keyValueIt = keyValue.iterator();
        Iterator<Buffer> certValueIt = certValue.iterator();
        int index = 0;
        while (keyValueIt.hasNext() && certValueIt.hasNext()) {
            PrivateKey key = KeyStoreHelper.loadPrivateKey(keyValueIt.next());
            Certificate[] chain = KeyStoreHelper.loadCerts(certValueIt.next());
            keyStore.setEntry("dummy-entry-" + index++, new KeyStore.PrivateKeyEntry(key, chain), new KeyStore.PasswordProtection(DUMMY_PASSWORD.toCharArray()));
        }
        return keyStore;
    }

    private static PrivateKey loadPrivateKey(Buffer keyValue) throws Exception {
        if (keyValue == null) {
            throw new RuntimeException("Missing private key path");
        }
        KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA");
        List pems = KeyStoreHelper.loadPems(keyValue, (delimiter, content) -> {
            try {
                switch (delimiter) {
                    case "RSA PRIVATE KEY": {
                        return Collections.singletonList(rsaKeyFactory.generatePrivate(PrivateKeyParser.getRSAKeySpec(content)));
                    }
                    case "PRIVATE KEY": {
                        return Collections.singletonList(rsaKeyFactory.generatePrivate(new PKCS8EncodedKeySpec((byte[])content)));
                    }
                }
                return Collections.emptyList();
            }
            catch (InvalidKeySpecException e) {
                throw new VertxException(e);
            }
        });
        if (pems.isEmpty()) {
            throw new RuntimeException("Missing -----BEGIN PRIVATE KEY----- or -----BEGIN RSA PRIVATE KEY----- delimiter");
        }
        return (PrivateKey)pems.get(0);
    }

    private static KeyStore loadCA(Stream<Buffer> certValues) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("jks");
        keyStore.load(null, null);
        int count = 0;
        Iterable iterable = certValues::iterator;
        for (Buffer certValue : iterable) {
            for (X509Certificate cert : KeyStoreHelper.loadCerts(certValue)) {
                keyStore.setCertificateEntry(DUMMY_CERT_ALIAS + count++, cert);
            }
        }
        return keyStore;
    }

    private static <P> List<P> loadPems(Buffer data, BiFunction<String, byte[], Collection<P>> pemFact) throws IOException {
        boolean begin;
        String pem = data.toString();
        ArrayList<P> pems = new ArrayList<P>();
        Matcher beginMatcher = BEGIN_PATTERN.matcher(pem);
        Matcher endMatcher = END_PATTERN.matcher(pem);
        while (begin = beginMatcher.find()) {
            String beginDelimiter = beginMatcher.group(1);
            boolean end = endMatcher.find();
            if (!end) {
                throw new RuntimeException("Missing -----END " + beginDelimiter + "----- delimiter");
            }
            String endDelimiter = endMatcher.group(1);
            if (!beginDelimiter.equals(endDelimiter)) {
                throw new RuntimeException("Missing -----END " + beginDelimiter + "----- delimiter");
            }
            String content = pem.substring(beginMatcher.end(), endMatcher.start());
            if ((content = content.replaceAll("\\s", "")).length() == 0) {
                throw new RuntimeException("Empty pem file");
            }
            Collection<P> pemItems = pemFact.apply(endDelimiter, Base64.getDecoder().decode(content));
            pems.addAll(pemItems);
        }
        return pems;
    }

    private static X509Certificate[] loadCerts(Buffer buffer) throws Exception {
        if (buffer == null) {
            throw new RuntimeException("Missing X.509 certificate path");
        }
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        List certs = KeyStoreHelper.loadPems(buffer, (delimiter, content) -> {
            try {
                switch (delimiter) {
                    case "CERTIFICATE": {
                        return certFactory.generateCertificates(new ByteArrayInputStream((byte[])content));
                    }
                }
                return Collections.emptyList();
            }
            catch (CertificateException e) {
                throw new VertxException(e);
            }
        });
        if (certs.isEmpty()) {
            throw new RuntimeException("Missing -----BEGIN CERTIFICATE----- delimiter");
        }
        return certs.toArray(new X509Certificate[certs.size()]);
    }
}

