/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.net.impl;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import znaishaded.io.netty.bootstrap.Bootstrap;
import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.ChannelHandler;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.channel.ChannelPipeline;
import znaishaded.io.netty.handler.logging.LoggingHandler;
import znaishaded.io.netty.handler.ssl.SslHandler;
import znaishaded.io.netty.handler.stream.ChunkedWriteHandler;
import znaishaded.io.netty.handler.timeout.IdleStateHandler;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Closeable;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.impl.ContextImpl;
import znaishaded.io.vertx.core.impl.VertxInternal;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.core.net.NetClient;
import znaishaded.io.vertx.core.net.NetClientOptions;
import znaishaded.io.vertx.core.net.NetSocket;
import znaishaded.io.vertx.core.net.SocketAddress;
import znaishaded.io.vertx.core.net.impl.ChannelProvider;
import znaishaded.io.vertx.core.net.impl.NetSocketImpl;
import znaishaded.io.vertx.core.net.impl.ProxyChannelProvider;
import znaishaded.io.vertx.core.net.impl.SSLHelper;
import znaishaded.io.vertx.core.net.impl.VertxNetHandler;
import znaishaded.io.vertx.core.spi.metrics.Metrics;
import znaishaded.io.vertx.core.spi.metrics.MetricsProvider;
import znaishaded.io.vertx.core.spi.metrics.TCPMetrics;
import znaishaded.io.vertx.core.spi.metrics.VertxMetrics;

public class NetClientImpl
implements MetricsProvider,
NetClient {
    private static final Logger log = LoggerFactory.getLogger(NetClientImpl.class);
    protected final int idleTimeout;
    protected final boolean logEnabled;
    private final VertxInternal vertx;
    private final NetClientOptions options;
    protected final SSLHelper sslHelper;
    private final Map<Channel, NetSocketImpl> socketMap = new ConcurrentHashMap<Channel, NetSocketImpl>();
    private final Closeable closeHook;
    private final ContextImpl creatingContext;
    private final TCPMetrics metrics;
    private volatile boolean closed;

    public NetClientImpl(VertxInternal vertx, NetClientOptions options) {
        this(vertx, options, true);
    }

    public NetClientImpl(VertxInternal vertx, NetClientOptions options, boolean useCreatingContext) {
        VertxMetrics metrics;
        this.vertx = vertx;
        this.options = new NetClientOptions(options);
        this.sslHelper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions());
        this.closeHook = completionHandler -> {
            this.close();
            completionHandler.handle(Future.succeededFuture());
        };
        if (useCreatingContext) {
            this.creatingContext = vertx.getContext();
            if (this.creatingContext != null) {
                if (this.creatingContext.isMultiThreadedWorkerContext()) {
                    throw new IllegalStateException("Cannot use NetClient in a multi-threaded worker verticle");
                }
                this.creatingContext.addCloseHook(this.closeHook);
            }
        } else {
            this.creatingContext = null;
        }
        this.metrics = (metrics = vertx.metricsSPI()) != null ? metrics.createMetrics(options) : null;
        this.logEnabled = options.getLogActivity();
        this.idleTimeout = options.getIdleTimeout();
    }

    protected void initChannel(ChannelPipeline pipeline) {
        if (this.logEnabled) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        if (this.sslHelper.isSSL()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (this.idleTimeout > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.idleTimeout));
        }
    }

    @Override
    public synchronized NetClient connect(int port2, String host, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.connect(port2, host, null, connectHandler);
        return this;
    }

    @Override
    public NetClient connect(int port2, String host, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.doConnect(SocketAddress.inetSocketAddress(port2, host), serverName, connectHandler != null ? ar -> connectHandler.handle(ar.map(s2 -> s2)) : null);
        return this;
    }

    @Override
    public void close() {
        if (!this.closed) {
            for (NetSocketImpl sock : this.socketMap.values()) {
                sock.close();
            }
            if (this.creatingContext != null) {
                this.creatingContext.removeCloseHook(this.closeHook);
            }
            this.closed = true;
            if (this.metrics != null) {
                this.metrics.close();
            }
        }
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null && this.metrics.isEnabled();
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Client is closed");
        }
    }

    private void applyConnectionOptions(Bootstrap bootstrap) {
        this.vertx.transport().configure(this.options, bootstrap);
    }

    @Override
    public NetClient connect(SocketAddress remoteAddress, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.doConnect(remoteAddress, serverName, connectHandler);
        return this;
    }

    @Override
    public NetClient connect(SocketAddress remoteAddress, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.doConnect(remoteAddress, null, connectHandler);
        return this;
    }

    protected void doConnect(SocketAddress remoteAddress, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.doConnect(remoteAddress, serverName, connectHandler, this.options.getReconnectAttempts());
    }

    protected void doConnect(SocketAddress remoteAddress, String serverName, Handler<AsyncResult<NetSocket>> connectHandler, int remainingAttempts) {
        this.checkClosed();
        Objects.requireNonNull(connectHandler, "No null connectHandler accepted");
        ContextImpl context = this.vertx.getOrCreateContext();
        this.sslHelper.validate(this.vertx);
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(context.nettyEventLoop());
        bootstrap.channel(this.vertx.transport().channelType(remoteAddress.path() != null));
        this.applyConnectionOptions(bootstrap);
        ChannelProvider channelProvider = this.options.getProxyOptions() == null ? ChannelProvider.INSTANCE : ProxyChannelProvider.INSTANCE;
        Handler<Channel> channelInitializer = ch -> {
            if (this.sslHelper.isSSL()) {
                SslHandler sslHandler = new SslHandler(this.sslHelper.createEngine(this.vertx, remoteAddress, serverName));
                ch.pipeline().addLast("ssl", (ChannelHandler)sslHandler);
            }
        };
        Handler<AsyncResult<Channel>> channelHandler = res -> {
            if (res.succeeded()) {
                Channel ch = (Channel)res.result();
                if (this.sslHelper.isSSL()) {
                    SslHandler sslHandler = (SslHandler)ch.pipeline().get("ssl");
                    znaishaded.io.netty.util.concurrent.Future<Channel> fut = sslHandler.handshakeFuture();
                    fut.addListener(future2 -> {
                        if (future2.isSuccess()) {
                            this.connected(context, ch, connectHandler, remoteAddress);
                        } else {
                            this.failed(context, ch, future2.cause(), connectHandler);
                        }
                    });
                } else {
                    this.connected(context, ch, connectHandler, remoteAddress);
                }
            } else if (remainingAttempts > 0 || remainingAttempts == -1) {
                context.executeFromIO(() -> {
                    log.debug("Failed to create connection. Will retry in " + this.options.getReconnectInterval() + " milliseconds");
                    this.vertx.setTimer(this.options.getReconnectInterval(), tid -> this.doConnect(remoteAddress, serverName, connectHandler, remainingAttempts == -1 ? remainingAttempts : remainingAttempts - 1));
                });
            } else {
                this.failed(context, null, res.cause(), connectHandler);
            }
        };
        channelProvider.connect(this.vertx, bootstrap, this.options.getProxyOptions(), remoteAddress, channelInitializer, channelHandler);
    }

    private void connected(ContextImpl context, Channel ch, Handler<AsyncResult<NetSocket>> connectHandler, SocketAddress remoteAddress) {
        ContextImpl.setContext(context);
        this.initChannel(ch.pipeline());
        VertxNetHandler handler = new VertxNetHandler(ctx -> new NetSocketImpl(this.vertx, (ChannelHandlerContext)ctx, remoteAddress, context, this.sslHelper, this.metrics)){

            @Override
            protected void handleMessage(NetSocketImpl connection, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
                connection.handleMessageReceived(msg);
            }
        };
        handler.addHandler(sock -> {
            this.socketMap.put(ch, (NetSocketImpl)sock);
            context.executeFromIO(() -> {
                if (this.metrics != null) {
                    sock.metric(this.metrics.connected(sock.remoteAddress(), sock.remoteName()));
                }
                connectHandler.handle(Future.succeededFuture(sock));
            });
        });
        handler.removeHandler(conn -> this.socketMap.remove(ch));
        ch.pipeline().addLast("handler", (ChannelHandler)handler);
    }

    private void failed(ContextImpl context, Channel ch, Throwable th, Handler<AsyncResult<NetSocket>> connectHandler) {
        if (ch != null) {
            ch.close();
        }
        context.executeFromIO(() -> this.doFailed(connectHandler, th));
    }

    private void doFailed(Handler<AsyncResult<NetSocket>> connectHandler, Throwable th) {
        connectHandler.handle(Future.failedFuture(th));
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

