/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.net.impl.transport;

import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.concurrent.ThreadFactory;
import znaishaded.io.netty.bootstrap.Bootstrap;
import znaishaded.io.netty.bootstrap.ServerBootstrap;
import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.ChannelOption;
import znaishaded.io.netty.channel.EventLoopGroup;
import znaishaded.io.netty.channel.FixedRecvByteBufAllocator;
import znaishaded.io.netty.channel.ServerChannel;
import znaishaded.io.netty.channel.nio.NioEventLoopGroup;
import znaishaded.io.netty.channel.socket.DatagramChannel;
import znaishaded.io.netty.channel.socket.InternetProtocolFamily;
import znaishaded.io.netty.channel.socket.nio.NioDatagramChannel;
import znaishaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import znaishaded.io.netty.channel.socket.nio.NioSocketChannel;
import znaishaded.io.vertx.core.datagram.DatagramSocketOptions;
import znaishaded.io.vertx.core.net.ClientOptionsBase;
import znaishaded.io.vertx.core.net.NetServerOptions;
import znaishaded.io.vertx.core.net.SocketAddress;
import znaishaded.io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import znaishaded.io.vertx.core.net.impl.transport.EpollTransport;
import znaishaded.io.vertx.core.net.impl.transport.KQueueTransport;

public class Transport {
    public static Transport JDK = new Transport();

    public static Transport nativeTransport() {
        Transport transport = null;
        try {
            EpollTransport epoll = new EpollTransport();
            if (((Transport)epoll).isAvailable()) {
                return epoll;
            }
            transport = epoll;
        }
        catch (Throwable epoll) {
            // empty catch block
        }
        try {
            KQueueTransport kqueue = new KQueueTransport();
            if (((Transport)kqueue).isAvailable()) {
                return kqueue;
            }
            if (transport == null) {
                transport = kqueue;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return transport;
    }

    Transport() {
    }

    public boolean isAvailable() {
        return true;
    }

    public Throwable unavailabilityCause() {
        return null;
    }

    public java.net.SocketAddress convert(SocketAddress address, boolean resolved) {
        if (address.path() != null) {
            throw new IllegalArgumentException("Domain socket not supported by JDK transport");
        }
        if (resolved) {
            return new InetSocketAddress(address.host(), address.port());
        }
        return InetSocketAddress.createUnresolved(address.host(), address.port());
    }

    ChannelOption<?> channelOption(String name) {
        return null;
    }

    public EventLoopGroup eventLoopGroup(int nThreads, ThreadFactory threadFactory, int ioRatio) {
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    public DatagramChannel datagramChannel() {
        return new NioDatagramChannel();
    }

    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        switch (family) {
            case IPv4: {
                return new NioDatagramChannel(InternetProtocolFamily.IPv4);
            }
            case IPv6: {
                return new NioDatagramChannel(InternetProtocolFamily.IPv6);
            }
        }
        throw new UnsupportedOperationException();
    }

    public Class<? extends Channel> channelType(boolean domain) {
        if (domain) {
            throw new IllegalArgumentException();
        }
        return NioSocketChannel.class;
    }

    public Class<? extends ServerChannel> serverChannelType(boolean domain) {
        if (domain) {
            throw new IllegalArgumentException();
        }
        return NioServerSocketChannel.class;
    }

    public void configure(DatagramChannel channel2, DatagramSocketOptions options) {
        channel2.config().setAllocator(PartialPooledByteBufAllocator.INSTANCE);
        if (options.getSendBufferSize() != -1) {
            channel2.config().setSendBufferSize(options.getSendBufferSize());
        }
        if (options.getReceiveBufferSize() != -1) {
            channel2.config().setReceiveBufferSize(options.getReceiveBufferSize());
            channel2.config().setRecvByteBufAllocator(new FixedRecvByteBufAllocator(options.getReceiveBufferSize()));
        }
        channel2.config().setOption(ChannelOption.SO_REUSEADDR, options.isReuseAddress());
        if (options.getTrafficClass() != -1) {
            channel2.config().setTrafficClass(options.getTrafficClass());
        }
        channel2.config().setBroadcast(options.isBroadcast());
        if (this == JDK) {
            channel2.config().setLoopbackModeDisabled(options.isLoopbackModeDisabled());
            if (options.getMulticastTimeToLive() != -1) {
                channel2.config().setTimeToLive(options.getMulticastTimeToLive());
            }
            if (options.getMulticastNetworkInterface() != null) {
                try {
                    channel2.config().setNetworkInterface(NetworkInterface.getByName(options.getMulticastNetworkInterface()));
                }
                catch (SocketException e) {
                    throw new IllegalArgumentException("Could not find network interface with name " + options.getMulticastNetworkInterface());
                }
            }
        }
    }

    public void configure(ClientOptionsBase options, Bootstrap bootstrap) {
        if (options.getLocalAddress() != null) {
            bootstrap.localAddress(options.getLocalAddress(), 0);
        }
        bootstrap.option(ChannelOption.TCP_NODELAY, options.isTcpNoDelay());
        if (options.getSendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, options.getSendBufferSize());
        }
        if (options.getReceiveBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, options.getReceiveBufferSize());
            bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, new FixedRecvByteBufAllocator(options.getReceiveBufferSize()));
        }
        if (options.getSoLinger() != -1) {
            bootstrap.option(ChannelOption.SO_LINGER, options.getSoLinger());
        }
        if (options.getTrafficClass() != -1) {
            bootstrap.option(ChannelOption.IP_TOS, options.getTrafficClass());
        }
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, options.getConnectTimeout());
        bootstrap.option(ChannelOption.ALLOCATOR, PartialPooledByteBufAllocator.INSTANCE);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, options.isTcpKeepAlive());
        bootstrap.option(ChannelOption.SO_REUSEADDR, options.isReuseAddress());
    }

    public void configure(NetServerOptions options, ServerBootstrap bootstrap) {
        bootstrap.childOption(ChannelOption.TCP_NODELAY, options.isTcpNoDelay());
        if (options.getSendBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, options.getSendBufferSize());
        }
        if (options.getReceiveBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, options.getReceiveBufferSize());
            bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, new FixedRecvByteBufAllocator(options.getReceiveBufferSize()));
        }
        if (options.getSoLinger() != -1) {
            bootstrap.childOption(ChannelOption.SO_LINGER, options.getSoLinger());
        }
        if (options.getTrafficClass() != -1) {
            bootstrap.childOption(ChannelOption.IP_TOS, options.getTrafficClass());
        }
        bootstrap.childOption(ChannelOption.ALLOCATOR, PartialPooledByteBufAllocator.INSTANCE);
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, options.isTcpKeepAlive());
        bootstrap.option(ChannelOption.SO_REUSEADDR, options.isReuseAddress());
        if (options.getAcceptBacklog() != -1) {
            bootstrap.option(ChannelOption.SO_BACKLOG, options.getAcceptBacklog());
        }
    }
}

