/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.spi.resolver;

import java.net.InetSocketAddress;
import znaishaded.io.netty.resolver.AddressResolverGroup;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.VertxException;
import znaishaded.io.vertx.core.dns.AddressResolverOptions;
import znaishaded.io.vertx.core.impl.VertxImpl;
import znaishaded.io.vertx.core.impl.resolver.DefaultResolverProvider;
import znaishaded.io.vertx.core.impl.resolver.DnsResolverProvider;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;

public interface ResolverProvider {
    public static final String DISABLE_DNS_RESOLVER_PROP_NAME = "vertx.disableDnsResolver";

    public static ResolverProvider factory(Vertx vertx, AddressResolverOptions options) {
        try {
            if (!Boolean.getBoolean(DISABLE_DNS_RESOLVER_PROP_NAME)) {
                return new DnsResolverProvider((VertxImpl)vertx, options);
            }
        }
        catch (Throwable e) {
            if (e instanceof VertxException) {
                throw e;
            }
            Logger logger = LoggerFactory.getLogger(ResolverProvider.class);
            logger.info("Using the default address resolver as the dns resolver could not be loaded");
        }
        return new DefaultResolverProvider();
    }

    public AddressResolverGroup<InetSocketAddress> resolver(AddressResolverOptions var1);

    public void close(Handler<Void> var1);
}

