/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.impl;

import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.ext.auth.AuthProvider;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.Session;
import znaishaded.io.vertx.ext.web.handler.impl.AuthHandlerImpl;
import znaishaded.io.vertx.ext.web.handler.impl.HttpStatusException;

public class RedirectAuthHandlerImpl
extends AuthHandlerImpl {
    private final String loginRedirectURL;
    private final String returnURLParam;

    public RedirectAuthHandlerImpl(AuthProvider authProvider, String loginRedirectURL, String returnURLParam) {
        super(authProvider);
        this.loginRedirectURL = loginRedirectURL;
        this.returnURLParam = returnURLParam;
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        Session session = context.session();
        if (session != null) {
            session.put(this.returnURLParam, context.request().uri());
            handler.handle(Future.failedFuture(new HttpStatusException(302, this.loginRedirectURL)));
        } else {
            handler.handle(Future.failedFuture("No session - did you forget to include a SessionHandler?"));
        }
    }
}

