/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.impl;

import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.ext.web.Cookie;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.Session;
import znaishaded.io.vertx.ext.web.handler.SessionHandler;
import znaishaded.io.vertx.ext.web.sstore.SessionStore;

public class SessionHandlerImpl
implements SessionHandler {
    private static final Logger log = LoggerFactory.getLogger(SessionHandlerImpl.class);
    private final SessionStore sessionStore;
    private String sessionCookieName;
    private long sessionTimeout;
    private boolean nagHttps;
    private boolean sessionCookieSecure;
    private boolean sessionCookieHttpOnly;
    private int minLength;

    public SessionHandlerImpl(String sessionCookieName, long sessionTimeout, boolean nagHttps, boolean sessionCookieSecure, boolean sessionCookieHttpOnly, int minLength, SessionStore sessionStore) {
        this.sessionCookieName = sessionCookieName;
        this.sessionTimeout = sessionTimeout;
        this.nagHttps = nagHttps;
        this.sessionStore = sessionStore;
        this.sessionCookieSecure = sessionCookieSecure;
        this.sessionCookieHttpOnly = sessionCookieHttpOnly;
        this.minLength = minLength;
    }

    @Override
    public SessionHandler setSessionTimeout(long timeout) {
        this.sessionTimeout = timeout;
        return this;
    }

    @Override
    public SessionHandler setNagHttps(boolean nag) {
        this.nagHttps = nag;
        return this;
    }

    @Override
    public SessionHandler setCookieSecureFlag(boolean secure) {
        this.sessionCookieSecure = secure;
        return this;
    }

    @Override
    public SessionHandler setCookieHttpOnlyFlag(boolean httpOnly) {
        this.sessionCookieHttpOnly = httpOnly;
        return this;
    }

    @Override
    public SessionHandler setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
        return this;
    }

    @Override
    public SessionHandler setMinLength(int minLength) {
        this.minLength = minLength;
        return this;
    }

    @Override
    public void handle(RoutingContext context) {
        String sessionID;
        Cookie cookie;
        String uri;
        context.response().ended();
        if (this.nagHttps && log.isDebugEnabled() && !(uri = context.request().absoluteURI()).startsWith("https:")) {
            log.debug("Using session cookies without https could make you susceptible to session hijacking: " + uri);
        }
        if ((cookie = context.getCookie(this.sessionCookieName)) != null && (sessionID = cookie.getValue()) != null && sessionID.length() > this.minLength) {
            this.getSession(context.vertx(), sessionID, res -> {
                if (res.succeeded()) {
                    Session session = (Session)res.result();
                    if (session != null) {
                        context.setSession(session);
                        session.setAccessed();
                        this.addStoreSessionHandler(context);
                    } else {
                        this.createNewSession(context);
                    }
                } else {
                    context.fail(res.cause());
                }
                context.next();
            });
            return;
        }
        this.createNewSession(context);
        context.next();
    }

    private void getSession(Vertx vertx, String sessionID, Handler<AsyncResult<Session>> resultHandler) {
        this.doGetSession(vertx, System.currentTimeMillis(), sessionID, resultHandler);
    }

    private void doGetSession(Vertx vertx, long startTime, String sessionID, Handler<AsyncResult<Session>> resultHandler) {
        this.sessionStore.get(sessionID, res -> {
            long retryTimeout;
            if (res.succeeded() && res.result() == null && (retryTimeout = this.sessionStore.retryTimeout()) > 0L && System.currentTimeMillis() - startTime < retryTimeout) {
                vertx.setTimer(5L, v -> this.doGetSession(vertx, startTime, sessionID, resultHandler));
                return;
            }
            resultHandler.handle((AsyncResult<Session>)res);
        });
    }

    private void addStoreSessionHandler(RoutingContext context) {
        context.addHeadersEndHandler(v -> {
            Session session = context.session();
            if (!session.isDestroyed()) {
                int currentStatusCode = context.response().getStatusCode();
                if (currentStatusCode >= 200 && currentStatusCode < 400) {
                    session.setAccessed();
                    if (session.isRegenerated()) {
                        Cookie cookie = context.getCookie(this.sessionCookieName);
                        cookie.setValue(session.id()).setPath("/").setSecure(this.sessionCookieSecure).setHttpOnly(this.sessionCookieHttpOnly);
                        this.sessionStore.delete(session.oldId(), delete -> {
                            if (delete.failed()) {
                                log.error((Object)"Failed to delete previous session", delete.cause());
                            } else {
                                this.sessionStore.put(session, res -> {
                                    if (res.failed()) {
                                        log.error((Object)"Failed to store session", res.cause());
                                    }
                                });
                            }
                        });
                    } else {
                        this.sessionStore.put(session, res -> {
                            if (res.failed()) {
                                log.error((Object)"Failed to store session", res.cause());
                            }
                        });
                    }
                } else {
                    context.removeCookie(this.sessionCookieName, false);
                }
            } else {
                this.sessionStore.delete(session.id(), res -> {
                    if (res.failed()) {
                        log.error((Object)"Failed to delete session", res.cause());
                    }
                });
            }
        });
    }

    private void createNewSession(RoutingContext context) {
        Session session = this.sessionStore.createSession(this.sessionTimeout, this.minLength);
        context.setSession(session);
        Cookie cookie = Cookie.cookie(this.sessionCookieName, session.id());
        cookie.setPath("/");
        cookie.setSecure(this.sessionCookieSecure);
        cookie.setHttpOnly(this.sessionCookieHttpOnly);
        context.addCookie(cookie);
        this.addStoreSessionHandler(context);
    }
}

