/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.io.netty.handler.codec.http.QueryStringDecoder;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.http.HttpMethod;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.ext.web.MIMEHeader;
import znaishaded.io.vertx.ext.web.Route;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.impl.BlockingHandlerDecorator;
import znaishaded.io.vertx.ext.web.impl.ParsableMIMEValue;
import znaishaded.io.vertx.ext.web.impl.RouterImpl;
import znaishaded.io.vertx.ext.web.impl.RoutingContextImplBase;
import znaishaded.io.vertx.ext.web.impl.Utils;

public class RouteImpl
implements Route {
    private static final Logger log = LoggerFactory.getLogger(RouteImpl.class);
    private final RouterImpl router;
    private final Set<HttpMethod> methods = new HashSet<HttpMethod>();
    private final Set<MIMEHeader> consumes = new LinkedHashSet<MIMEHeader>();
    private final Set<MIMEHeader> produces = new LinkedHashSet<MIMEHeader>();
    private String path;
    private int order;
    private boolean enabled = true;
    private List<Handler<RoutingContext>> contextHandlers;
    private List<Handler<RoutingContext>> failureHandlers;
    private boolean added;
    private Pattern pattern;
    private List<String> groups;
    private boolean useNormalisedPath = true;
    private Set<String> namedGroupsInRegex = new TreeSet<String>();
    private static final Pattern RE_OPERATORS_NO_STAR = Pattern.compile("([\\(\\)\\$\\+\\.])");
    private boolean exactPath;

    RouteImpl(RouterImpl router, int order) {
        this.router = router;
        this.order = order;
        this.contextHandlers = new ArrayList<Handler<RoutingContext>>();
        this.failureHandlers = new ArrayList<Handler<RoutingContext>>();
    }

    RouteImpl(RouterImpl router, int order, HttpMethod method, String path2) {
        this(router, order);
        this.methods.add(method);
        this.checkPath(path2);
        this.setPath(path2);
    }

    RouteImpl(RouterImpl router, int order, String path2) {
        this(router, order);
        this.checkPath(path2);
        this.setPath(path2);
    }

    RouteImpl(RouterImpl router, int order, HttpMethod method, String regex, boolean bregex) {
        this(router, order);
        this.methods.add(method);
        this.setRegex(regex);
    }

    RouteImpl(RouterImpl router, int order, String regex, boolean bregex) {
        this(router, order);
        this.setRegex(regex);
    }

    @Override
    public synchronized Route method(HttpMethod method) {
        this.methods.add(method);
        return this;
    }

    @Override
    public synchronized Route path(String path2) {
        this.checkPath(path2);
        this.setPath(path2);
        return this;
    }

    @Override
    public synchronized Route pathRegex(String regex) {
        this.setRegex(regex);
        return this;
    }

    @Override
    public synchronized Route produces(String contentType) {
        ParsableMIMEValue value = new ParsableMIMEValue(contentType).forceParse();
        this.produces.add(value);
        return this;
    }

    @Override
    public synchronized Route consumes(String contentType) {
        ParsableMIMEValue value = new ParsableMIMEValue(contentType).forceParse();
        this.consumes.add(value);
        return this;
    }

    @Override
    public synchronized Route order(int order) {
        if (this.added) {
            throw new IllegalStateException("Can't change order after route is active");
        }
        this.order = order;
        return this;
    }

    @Override
    public synchronized Route last() {
        return this.order(Integer.MAX_VALUE);
    }

    @Override
    public synchronized Route handler(Handler<RoutingContext> contextHandler) {
        this.contextHandlers.add(contextHandler);
        this.checkAdd();
        return this;
    }

    @Override
    public Route blockingHandler(Handler<RoutingContext> contextHandler) {
        return this.blockingHandler(contextHandler, true);
    }

    @Override
    public synchronized Route blockingHandler(Handler<RoutingContext> contextHandler, boolean ordered) {
        return this.handler(new BlockingHandlerDecorator(contextHandler, ordered));
    }

    @Override
    public synchronized Route failureHandler(Handler<RoutingContext> exceptionHandler) {
        this.failureHandlers.add(exceptionHandler);
        this.checkAdd();
        return this;
    }

    @Override
    public synchronized Route remove() {
        this.router.remove(this);
        return this;
    }

    @Override
    public synchronized Route disable() {
        this.enabled = false;
        return this;
    }

    @Override
    public synchronized Route enable() {
        this.enabled = true;
        return this;
    }

    @Override
    public Route useNormalisedPath(boolean useNormalisedPath) {
        this.useNormalisedPath = useNormalisedPath;
        return this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Route setRegexGroupsNames(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Route[ ");
        sb.append("path:").append(this.path);
        sb.append(" pattern:").append(this.pattern);
        sb.append(" handlers:").append(this.contextHandlers);
        sb.append(" failureHandlers:").append(this.failureHandlers);
        sb.append(" order:").append(this.order);
        sb.append(" methods:[");
        int cnt = 0;
        for (HttpMethod method : this.methods) {
            sb.append((Object)method);
            if (++cnt >= this.methods.size()) continue;
            sb.append(",");
        }
        sb.append("]]@").append(System.identityHashCode(this));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleContext(RoutingContextImplBase context) {
        Handler<RoutingContext> contextHandler;
        RouteImpl routeImpl = this;
        synchronized (routeImpl) {
            contextHandler = this.contextHandlers.get(context.currentRouteNextHandlerIndex() - 1);
        }
        contextHandler.handle(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleFailure(RoutingContextImplBase context) {
        Handler<RoutingContext> failureHandler;
        RouteImpl routeImpl = this;
        synchronized (routeImpl) {
            failureHandler = this.failureHandlers.get(context.currentRouteNextFailureHandlerIndex() - 1);
        }
        failureHandler.handle(context);
    }

    /*
     * WARNING - void declaration
     */
    synchronized boolean matches(RoutingContextImplBase context, String mountPoint, boolean failure) {
        MIMEHeader contentType;
        MIMEHeader consumal;
        if (failure && !this.hasNextFailureHandler(context) || !failure && !this.hasNextContextHandler(context)) {
            return false;
        }
        if (!this.enabled) {
            return false;
        }
        HttpServerRequest request = context.request();
        if (!this.methods.isEmpty() && !this.methods.contains((Object)request.method())) {
            return false;
        }
        if (this.path != null && this.pattern == null && !this.pathMatches(mountPoint, context)) {
            return false;
        }
        if (this.pattern != null) {
            Object m3;
            String path2;
            String string = path2 = this.useNormalisedPath ? Utils.normalizePath(context.request().path()) : context.request().path();
            if (mountPoint != null) {
                path2 = path2.substring(mountPoint.length());
            }
            if (((Matcher)(m3 = this.pattern.matcher(path2))).matches()) {
                if (((Matcher)m3).groupCount() > 0) {
                    if (this.groups != null) {
                        void var7_8;
                        boolean bl = false;
                        while (var7_8 < this.groups.size()) {
                            String undecodedValue;
                            String k = this.groups.get((int)var7_8);
                            try {
                                undecodedValue = ((Matcher)m3).group("p" + (int)var7_8);
                            }
                            catch (IllegalArgumentException e) {
                                try {
                                    undecodedValue = ((Matcher)m3).group(k);
                                }
                                catch (IllegalArgumentException e1) {
                                    undecodedValue = ((Matcher)m3).group((int)(var7_8 + true));
                                }
                            }
                            this.addPathParam(context, k, undecodedValue);
                            ++var7_8;
                        }
                    } else {
                        void var7_11;
                        for (String namedGroup : this.namedGroupsInRegex) {
                            String namedGroupValue = ((Matcher)m3).group(namedGroup);
                            if (namedGroupValue == null) continue;
                            this.addPathParam(context, namedGroup, namedGroupValue);
                        }
                        boolean bl = false;
                        while (var7_11 < ((Matcher)m3).groupCount()) {
                            String group = ((Matcher)m3).group((int)(var7_11 + true));
                            if (group != null) {
                                String k = "param" + (int)var7_11;
                                this.addPathParam(context, k, group);
                            }
                            ++var7_11;
                        }
                    }
                }
            } else {
                return false;
            }
        }
        if (context.queryParams().size() == 0) {
            Map<String, List<String>> decodedParams = new QueryStringDecoder(request.uri()).parameters();
            for (Map.Entry entry : decodedParams.entrySet()) {
                context.queryParams().add((String)entry.getKey(), (Iterable)entry.getValue());
            }
        }
        if (!this.consumes.isEmpty() && (consumal = (contentType = context.parsedHeaders().contentType()).findMatchedBy(this.consumes)) == null) {
            return false;
        }
        List<MIMEHeader> acceptableTypes = context.parsedHeaders().accept();
        if (!this.produces.isEmpty() && !acceptableTypes.isEmpty()) {
            MIMEHeader selectedAccept = context.parsedHeaders().findBestUserAcceptedIn(acceptableTypes, this.produces);
            if (selectedAccept != null) {
                context.setAcceptableContentType(selectedAccept.rawValue());
                return true;
            }
            return false;
        }
        return true;
    }

    private void addPathParam(RoutingContext context, String name, String value) {
        HttpServerRequest request = context.request();
        String decodedValue = Utils.urlDecode(value, false);
        if (!request.params().contains(name)) {
            request.params().add(name, decodedValue);
        }
        context.pathParams().put(name, decodedValue);
    }

    RouterImpl router() {
        return this.router;
    }

    private boolean pathMatches(String mountPoint, RoutingContext ctx) {
        String requestPath;
        String thePath;
        String string = thePath = mountPoint == null ? this.path : mountPoint + this.path;
        if (this.useNormalisedPath) {
            requestPath = Utils.normalizePath(ctx.request().path());
        } else {
            requestPath = ctx.request().path();
            if (requestPath == null) {
                requestPath = "/";
            }
        }
        if (this.exactPath) {
            return this.pathMatchesExact(requestPath, thePath);
        }
        if (thePath.endsWith("/") && requestPath.equals(this.removeTrailing(thePath))) {
            return true;
        }
        return requestPath.startsWith(thePath);
    }

    private boolean pathMatchesExact(String path1, String path2) {
        return this.removeTrailing(path1).equals(this.removeTrailing(path2));
    }

    private String removeTrailing(String path2) {
        int i = path2.length();
        if (path2.charAt(i - 1) == '/') {
            path2 = path2.substring(0, i - 1);
        }
        return path2;
    }

    private void setPath(String path2) {
        if (path2.indexOf(58) != -1) {
            this.createPatternRegex(path2);
            this.path = path2;
        } else if (path2.charAt(path2.length() - 1) != '*') {
            this.exactPath = true;
            this.path = path2;
        } else {
            this.exactPath = false;
            this.path = path2.substring(0, path2.length() - 1);
        }
    }

    private void setRegex(String regex) {
        this.pattern = Pattern.compile(regex);
        Set<String> namedGroups = this.findNamedGroups(this.pattern.pattern());
        if (!namedGroups.isEmpty()) {
            this.namedGroupsInRegex.addAll(namedGroups);
        }
    }

    private Set<String> findNamedGroups(String path2) {
        TreeSet<String> namedGroups = new TreeSet<String>();
        Matcher m3 = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>").matcher(path2);
        while (m3.find()) {
            namedGroups.add(m3.group(1));
        }
        return namedGroups;
    }

    private void createPatternRegex(String path2) {
        if ((path2 = RE_OPERATORS_NO_STAR.matcher(path2).replaceAll("\\\\$1")).charAt(path2.length() - 1) == '*') {
            path2 = path2.substring(0, path2.length() - 1) + ".*";
        }
        Matcher m3 = Pattern.compile(":([A-Za-z][A-Za-z0-9_]*)").matcher(path2);
        StringBuffer sb = new StringBuffer();
        this.groups = new ArrayList<String>();
        int index = 0;
        while (m3.find()) {
            String param = "p" + index;
            String group = m3.group().substring(1);
            if (this.groups.contains(group)) {
                throw new IllegalArgumentException("Cannot use identifier " + group + " more than once in pattern string");
            }
            m3.appendReplacement(sb, "(?<" + param + ">[^/]+)");
            this.groups.add(group);
            ++index;
        }
        m3.appendTail(sb);
        path2 = sb.toString();
        this.pattern = Pattern.compile(path2);
    }

    private void checkPath(String path2) {
        if ("".equals(path2) || path2.charAt(0) != '/') {
            throw new IllegalArgumentException("Path must start with /");
        }
    }

    int order() {
        return this.order;
    }

    private void checkAdd() {
        if (!this.added) {
            this.router.add(this);
            this.added = true;
        }
    }

    protected synchronized boolean hasNextContextHandler(RoutingContextImplBase context) {
        return context.currentRouteNextHandlerIndex() < this.contextHandlers.size();
    }

    protected synchronized boolean hasNextFailureHandler(RoutingContextImplBase context) {
        return context.currentRouteNextFailureHandlerIndex() < this.failureHandlers.size();
    }
}

