/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.impl;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import znaishaded.io.netty.handler.codec.http.HttpResponseStatus;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.ext.web.Route;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.impl.HttpServerRequestWrapper;
import znaishaded.io.vertx.ext.web.impl.RouteImpl;
import znaishaded.io.vertx.ext.web.impl.RouterImpl;

public abstract class RoutingContextImplBase
implements RoutingContext {
    static final Logger log = LoggerFactory.getLogger(RoutingContextImplBase.class);
    private final Set<RouteImpl> routes;
    protected final String mountPoint;
    protected final HttpServerRequest request;
    protected Iterator<RouteImpl> iter;
    protected RouteImpl currentRoute;
    protected AtomicInteger currentRouteNextHandlerIndex;
    protected AtomicInteger currentRouteNextFailureHandlerIndex;

    protected RoutingContextImplBase(String mountPoint, HttpServerRequest request, Set<RouteImpl> routes) {
        this.mountPoint = mountPoint;
        this.request = new HttpServerRequestWrapper(request);
        this.routes = routes;
        this.iter = routes.iterator();
        this.currentRouteNextHandlerIndex = new AtomicInteger(0);
        this.currentRouteNextFailureHandlerIndex = new AtomicInteger(0);
    }

    @Override
    public String mountPoint() {
        return this.mountPoint;
    }

    @Override
    public Route currentRoute() {
        return this.currentRoute;
    }

    protected int currentRouteNextHandlerIndex() {
        return this.currentRouteNextHandlerIndex.intValue();
    }

    protected int currentRouteNextFailureHandlerIndex() {
        return this.currentRouteNextFailureHandlerIndex.intValue();
    }

    protected void restart() {
        this.iter = this.routes.iterator();
        this.currentRoute = null;
        this.next();
    }

    protected boolean iterateNext() {
        boolean failed = this.failed();
        if (this.currentRoute != null) {
            try {
                if (!failed && this.currentRoute.hasNextContextHandler(this)) {
                    this.currentRouteNextHandlerIndex.incrementAndGet();
                    this.currentRoute.handleContext(this);
                    return true;
                }
                if (failed && this.currentRoute.hasNextFailureHandler(this)) {
                    this.currentRouteNextFailureHandlerIndex.incrementAndGet();
                    this.currentRoute.handleFailure(this);
                    return true;
                }
            }
            catch (Throwable t) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Throwable thrown from handler", t);
                }
                if (!failed) {
                    if (log.isTraceEnabled()) {
                        log.trace("Failing the routing");
                    }
                    this.fail(t);
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace("Failure in handling failure");
                    }
                    this.unhandledFailure(-1, t, this.currentRoute.router());
                }
                return true;
            }
        }
        while (this.iter.hasNext()) {
            RouteImpl route2 = this.iter.next();
            this.currentRouteNextHandlerIndex.set(0);
            this.currentRouteNextFailureHandlerIndex.set(0);
            try {
                if (!route2.matches(this, this.mountPoint(), failed)) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Route matches: " + route2);
                }
                try {
                    this.currentRoute = route2;
                    if (log.isTraceEnabled()) {
                        log.trace("Calling the " + (failed ? "failure" : "") + " handler");
                    }
                    if (failed && this.currentRoute.hasNextFailureHandler(this)) {
                        this.currentRouteNextFailureHandlerIndex.incrementAndGet();
                        route2.handleFailure(this);
                    } else {
                        if (!this.currentRoute.hasNextContextHandler(this)) continue;
                        this.currentRouteNextHandlerIndex.incrementAndGet();
                        route2.handleContext(this);
                    }
                }
                catch (Throwable t) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Throwable thrown from handler", t);
                    }
                    if (!failed) {
                        if (log.isTraceEnabled()) {
                            log.trace("Failing the routing");
                        }
                        this.fail(t);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("Failure in handling failure");
                    }
                    this.unhandledFailure(-1, t, route2.router());
                }
                return true;
            }
            catch (IllegalArgumentException e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"IllegalArgumentException thrown during iteration", e);
                }
                this.unhandledFailure(400, e, route2.router());
                return true;
            }
        }
        return false;
    }

    protected void unhandledFailure(int statusCode, Throwable failure, RouterImpl router) {
        int code;
        int n = code = statusCode != -1 ? statusCode : 500;
        if (failure != null) {
            if (router.exceptionHandler() != null) {
                router.exceptionHandler().handle(failure);
            } else {
                log.error((Object)"Unexpected exception in route", failure);
            }
        }
        if (!this.response().ended()) {
            try {
                this.response().setStatusCode(code);
            }
            catch (IllegalArgumentException e) {
                this.response().setStatusMessage(HttpResponseStatus.valueOf(code).reasonPhrase()).setStatusCode(code);
            }
            this.response().end(this.response().getStatusMessage());
        }
    }
}

