/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.sstore.impl;

import java.util.HashSet;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.shareddata.LocalMap;
import znaishaded.io.vertx.ext.auth.PRNG;
import znaishaded.io.vertx.ext.web.Session;
import znaishaded.io.vertx.ext.web.sstore.LocalSessionStore;
import znaishaded.io.vertx.ext.web.sstore.impl.SessionImpl;

public class LocalSessionStoreImpl
implements LocalSessionStore,
Handler<Long> {
    private final LocalMap<String, Session> localMap;
    private final long reaperInterval;
    private final PRNG random;
    private long timerID = -1L;
    private boolean closed;
    protected final Vertx vertx;

    public LocalSessionStoreImpl(Vertx vertx, String sessionMapName, long reaperInterval) {
        this.random = new PRNG(vertx);
        this.vertx = vertx;
        this.reaperInterval = reaperInterval;
        this.localMap = vertx.sharedData().getLocalMap(sessionMapName);
        this.setTimer();
    }

    @Override
    public Session createSession(long timeout) {
        return new SessionImpl(this.random, timeout, 16);
    }

    @Override
    public Session createSession(long timeout, int length) {
        return new SessionImpl(this.random, timeout, length);
    }

    @Override
    public long retryTimeout() {
        return 0L;
    }

    @Override
    public void get(String id, Handler<AsyncResult<Session>> resultHandler) {
        resultHandler.handle(Future.succeededFuture(this.localMap.get(id)));
    }

    @Override
    public void delete(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.localMap.remove(id);
        resultHandler.handle(Future.succeededFuture());
    }

    @Override
    public void put(Session session, Handler<AsyncResult<Void>> resultHandler) {
        SessionImpl oldSession = (SessionImpl)this.localMap.get(session.id());
        SessionImpl newSession = (SessionImpl)session;
        if (oldSession != null && oldSession.version() != newSession.version()) {
            resultHandler.handle(Future.failedFuture("Version mismatch"));
            return;
        }
        newSession.incrementVersion();
        this.localMap.put(session.id(), session);
        resultHandler.handle(Future.succeededFuture());
    }

    @Override
    public void clear(Handler<AsyncResult<Void>> resultHandler) {
        this.localMap.clear();
        resultHandler.handle(Future.succeededFuture());
    }

    @Override
    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        resultHandler.handle(Future.succeededFuture(this.localMap.size()));
    }

    @Override
    public synchronized void close() {
        this.localMap.close();
        if (this.timerID != -1L) {
            this.vertx.cancelTimer(this.timerID);
        }
        this.random.close();
        this.closed = true;
    }

    @Override
    public synchronized void handle(Long tid) {
        long now = System.currentTimeMillis();
        HashSet<String> toRemove = new HashSet<String>();
        for (Session session : this.localMap.values()) {
            if (now - session.lastAccessed() <= session.timeout()) continue;
            toRemove.add(session.id());
        }
        for (String id : toRemove) {
            this.localMap.remove(id);
        }
        if (!this.closed) {
            this.setTimer();
        }
    }

    private void setTimer() {
        if (this.reaperInterval != 0L) {
            this.timerID = this.vertx.setTimer(this.reaperInterval, this);
        }
    }
}

