/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometryMerger;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileGeometry
extends Dimension2D {
    private final double width;
    private final double height;
    private final double left;
    private final double inY;
    private final double outY;

    public FtileGeometry(Dimension2D dimension2D, double d, double d2) {
        this(dimension2D.getWidth(), dimension2D.getHeight(), d, d2);
    }

    public FtileGeometry(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, Double.MIN_NORMAL);
    }

    public String toString() {
        return "[" + this.width + "x" + this.height + " left=" + this.left + "]";
    }

    public void setSize(double d, double d2) {
        throw new UnsupportedOperationException();
    }

    public FtileGeometry(double d, double d2, double d3, double d4, double d5) {
        this.left = d3;
        this.inY = d4;
        this.outY = d5;
        this.width = d;
        this.height = d2;
    }

    public FtileGeometry incHeight(double d) {
        return new FtileGeometry(this.width, this.height + d, this.left, this.inY, this.outY);
    }

    public FtileGeometry(Dimension2D dimension2D, double d, double d2, double d3) {
        this(dimension2D.getWidth(), dimension2D.getHeight(), d, d2, d3);
    }

    public boolean hasPointOut() {
        return this.outY != Double.MIN_NORMAL;
    }

    public Point2D getPointIn() {
        return new Point2D.Double(this.left, this.inY);
    }

    public Point2D getPointOut() {
        if (this.outY == Double.MIN_NORMAL) {
            throw new UnsupportedOperationException();
        }
        return new Point2D.Double(this.left, this.outY);
    }

    public FtileGeometry withoutPointOut() {
        return new FtileGeometry(this.width, this.height, this.left, this.inY);
    }

    public FtileGeometry translate(UTranslate uTranslate) {
        double d = uTranslate.getDx();
        double d2 = uTranslate.getDy();
        if (this.outY == Double.MIN_NORMAL) {
            return new FtileGeometry(this.width, this.height, this.left + d, this.inY + d2);
        }
        return new FtileGeometry(this.width, this.height, this.left + d, this.inY + d2, this.outY + d2);
    }

    public final double getInY() {
        return this.inY;
    }

    public final double getLeft() {
        return this.left;
    }

    public double getOutY() {
        return this.outY;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public FtileGeometry addDim(double d, double d2) {
        return new FtileGeometry(this.width + d, this.height + d2, this.left, this.inY, this.outY + d2);
    }

    public FtileGeometry addMarginX(double d) {
        return new FtileGeometry(this.width + 2.0 * d, this.height, this.left + d, this.inY, this.outY);
    }

    public FtileGeometry addMarginX(double d, double d2) {
        return new FtileGeometry(this.width + d + d2, this.height, this.left + d, this.inY, this.outY);
    }

    public FtileGeometry fixedHeight(double d) {
        return new FtileGeometry(this.width, d, this.left, this.inY, this.outY);
    }

    public FtileGeometry appendBottom(FtileGeometry ftileGeometry) {
        return new FtileGeometryMerger(this, ftileGeometry).getResult();
    }

    public FtileGeometry ensureHeight(double d) {
        if (this.height > d) {
            return this;
        }
        return this.fixedHeight(d);
    }

    private FtileGeometry ensureRightStrange(double d) {
        double d2 = this.width - this.left;
        if (d2 > d) {
            return this;
        }
        return this.addMarginX(0.0, d);
    }
}

