/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FtileForkInner
extends AbstractFtile {
    private final List<Ftile> forks = new ArrayList<Ftile>();

    public FtileForkInner(List<Ftile> list) {
        super(list.get(0).skinParam());
        for (Ftile ftile : list) {
            this.forks.add(ftile);
        }
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.forks.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return FtileForkInner.mergeSwimlanes(this.forks);
    }

    public static Set<Swimlane> mergeSwimlanes(List<Ftile> list) {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        for (Ftile ftile : list) {
            hashSet.addAll(ftile.getSwimlanes());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = 0.0;
        for (Ftile ftile : this.forks) {
            uGraphic.apply(new UTranslate(d, 0.0)).draw(ftile);
            FtileGeometry ftileGeometry = ftile.calculateDimension(stringBounder);
            d += ((Dimension2D)ftileGeometry).getWidth();
        }
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        double d = 0.0;
        double d2 = 0.0;
        for (Ftile ftile : this.forks) {
            FtileGeometry ftileGeometry = ftile.calculateDimension(stringBounder);
            d2 += ((Dimension2D)ftileGeometry).getWidth();
            if (!(((Dimension2D)ftileGeometry).getHeight() > d)) continue;
            d = ((Dimension2D)ftileGeometry).getHeight();
        }
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(d2, d);
        return new FtileGeometry(dimension2DDouble, ((Dimension2D)dimension2DDouble).getWidth() / 2.0, 0.0, ((Dimension2D)dimension2DDouble).getHeight());
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        double d = 0.0;
        for (Ftile ftile2 : this.forks) {
            if (ftile2 == ftile) {
                return new UTranslate(d, 0.0);
            }
            FtileGeometry ftileGeometry = ftile2.calculateDimension(stringBounder);
            d += ((Dimension2D)ftileGeometry).getWidth();
        }
        throw new IllegalArgumentException();
    }
}

