/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import znaishaded.net.sourceforge.plantuml.Direction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Branch;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfWithDiamonds;
import znaishaded.net.sourceforge.plantuml.graphic.Rainbow;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileIfWithLinks
extends FtileIfWithDiamonds {
    private final Rainbow arrowColor;

    public FtileIfWithLinks(Ftile ftile, Ftile ftile2, Ftile ftile3, Ftile ftile4, Swimlane swimlane, Rainbow rainbow, StringBounder stringBounder) {
        super(ftile, ftile2, ftile3, ftile4, swimlane, stringBounder);
        this.arrowColor = rainbow;
        if (rainbow.size() == 0) {
            throw new IllegalArgumentException();
        }
    }

    public static Rainbow getInColor(Branch branch, Rainbow rainbow) {
        Rainbow rainbow2;
        if (branch.isEmpty()) {
            return branch.getFtile().getOutLinkRendering().getRainbow(rainbow);
        }
        LinkRendering linkRendering = branch.getFtile().getInLinkRendering();
        Rainbow rainbow3 = rainbow2 = linkRendering == null ? rainbow : linkRendering.getRainbow();
        if (rainbow2.size() == 0) {
            return rainbow;
        }
        return rainbow2;
    }

    public Ftile addLinks(Branch branch, Branch branch2, StringBounder stringBounder) {
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        arrayList.add(new ConnectionHorizontalThenVertical(this.tile1, branch));
        arrayList.add(new ConnectionHorizontalThenVertical(this.tile2, branch2));
        boolean bl = this.tile1.calculateDimension(stringBounder).hasPointOut();
        boolean bl2 = this.tile2.calculateDimension(stringBounder).hasPointOut();
        if (bl && bl2) {
            arrayList.add(new ConnectionVerticalThenHorizontal(this.tile1, branch.getInlinkRenderingColorAndStyle(), branch.isEmpty()));
            arrayList.add(new ConnectionVerticalThenHorizontal(this.tile2, branch2.getInlinkRenderingColorAndStyle(), branch2.isEmpty()));
        } else if (bl && !bl2) {
            arrayList.add(new ConnectionVerticalThenHorizontalDirect(this.tile1, branch.getInlinkRenderingColorAndStyle(), branch.isEmpty()));
        } else if (!bl && bl2) {
            arrayList.add(new ConnectionVerticalThenHorizontalDirect(this.tile2, branch2.getInlinkRenderingColorAndStyle(), branch2.isEmpty()));
        }
        return FtileUtils.addConnection((Ftile)this, arrayList);
    }

    class ConnectionVerticalThenHorizontalDirect
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow myArrowColor;
        private final boolean branchEmpty;

        public ConnectionVerticalThenHorizontalDirect(Ftile ftile, Rainbow rainbow, boolean bl) {
            super(ftile, FtileIfWithLinks.this.diamond2);
            this.myArrowColor = rainbow == null || rainbow.size() == 0 ? FtileIfWithLinks.this.arrowColor : rainbow;
            this.branchEmpty = bl;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            FtileGeometry ftileGeometry = FtileIfWithLinks.this.calculateDimensionInternal(stringBounder);
            FtileGeometry ftileGeometry2 = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry2.hasPointOut()) {
                return;
            }
            Point2D point2D = ftileGeometry2.translate(this.translate(stringBounder)).getPointOut();
            Point2D.Double double_ = new Point2D.Double(ftileGeometry.getLeft(), ftileGeometry.getHeight());
            double d = point2D.getX();
            double d2 = point2D.getY();
            double d3 = ((Point2D)double_).getX();
            double d4 = ((Point2D)double_).getY();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.myArrowColor);
            if (this.branchEmpty) {
                snake.emphasizeDirection(Direction.DOWN);
            }
            snake.addPoint(d, d2);
            snake.addPoint(d, d4);
            snake.addPoint(d3, d4);
            snake.addPoint(d3, ftileGeometry.getHeight());
            uGraphic.draw(snake);
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            FtileGeometry ftileGeometry = FtileIfWithLinks.this.calculateDimensionInternal(stringBounder);
            FtileGeometry ftileGeometry2 = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry2.hasPointOut()) {
                return;
            }
            Point2D point2D = ftileGeometry2.translate(this.translate(stringBounder)).getPointOut();
            Point2D.Double double_ = new Point2D.Double(ftileGeometry.getLeft(), ftileGeometry.getHeight() - 12.0);
            Point2D point2D2 = uTranslate.getTranslated(point2D);
            Point2D point2D3 = uTranslate2.getTranslated(double_);
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.myArrowColor);
            double d = point2D2.getX();
            double d2 = point2D3.getX();
            double d3 = point2D3.getY();
            snake.addPoint(point2D2);
            snake.addPoint(d, d3);
            snake.addPoint(point2D3);
            snake.addPoint(d2, ftileGeometry.getHeight());
            snake.goUnmergeable(MergeStrategy.LIMITED);
            uGraphic.draw(snake);
        }

        private UTranslate translate(StringBounder stringBounder) {
            if (this.getFtile1() == FtileIfWithLinks.this.tile1) {
                return FtileIfWithLinks.this.getTranslate1(stringBounder);
            }
            if (this.getFtile1() == FtileIfWithLinks.this.tile2) {
                return FtileIfWithLinks.this.getTranslate2(stringBounder);
            }
            throw new IllegalStateException();
        }
    }

    class ConnectionVerticalThenHorizontal
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow myArrowColor;
        private final boolean branchEmpty;

        public ConnectionVerticalThenHorizontal(Ftile ftile, Rainbow rainbow, boolean bl) {
            super(ftile, FtileIfWithLinks.this.diamond2);
            this.myArrowColor = rainbow == null || rainbow.size() == 0 ? FtileIfWithLinks.this.arrowColor : rainbow;
            this.branchEmpty = bl;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Point2D point2D = ftileGeometry.translate(this.translate(stringBounder)).getPointOut();
            Point2D point2D2 = this.getP2(stringBounder);
            double d = point2D.getX();
            double d2 = point2D.getY();
            double d3 = point2D2.getX();
            double d4 = point2D2.getY();
            UPolygon uPolygon = d3 > d ? Arrows.asToRight() : Arrows.asToLeft();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.myArrowColor, uPolygon);
            if (this.branchEmpty) {
                snake.emphasizeDirection(Direction.DOWN);
            }
            snake.addPoint(d, d2);
            snake.addPoint(d, d4);
            snake.addPoint(d3, d4);
            uGraphic.draw(snake);
        }

        private Point2D getP2(StringBounder stringBounder) {
            double d;
            FtileGeometry ftileGeometry = FtileIfWithLinks.this.diamond2.calculateDimension(stringBounder);
            double d2 = ((Dimension2D)ftileGeometry).getWidth();
            if (this.getFtile1() == FtileIfWithLinks.this.tile1) {
                d = 0.0;
            } else if (this.getFtile1() == FtileIfWithLinks.this.tile2) {
                d = d2;
            } else {
                throw new IllegalStateException();
            }
            return FtileIfWithLinks.this.getTranslateDiamond2(stringBounder).getTranslated(new Point2D.Double(d, ((Dimension2D)ftileGeometry).getHeight() / 2.0));
        }

        private UTranslate translate(StringBounder stringBounder) {
            if (this.getFtile1() == FtileIfWithLinks.this.tile1) {
                return FtileIfWithLinks.this.getTranslate1(stringBounder);
            }
            if (this.getFtile1() == FtileIfWithLinks.this.tile2) {
                return FtileIfWithLinks.this.getTranslate2(stringBounder);
            }
            throw new IllegalStateException();
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            UPolygon uPolygon;
            StringBounder stringBounder = uGraphic.getStringBounder();
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Point2D point2D = this.getP2(stringBounder);
            Point2D point2D2 = ftileGeometry.translate(this.translate(stringBounder)).getPointOut();
            Direction direction = Direction.leftOrRight(point2D2, point2D);
            double d = point2D2.getX();
            double d2 = point2D.getX();
            Point2D point2D3 = uTranslate.getTranslated(point2D2);
            Point2D point2D4 = uTranslate2.getTranslated(point2D);
            Direction direction2 = Direction.leftOrRight(point2D3, point2D4);
            UPolygon uPolygon2 = uPolygon = d2 > d ? Arrows.asToRight() : Arrows.asToLeft();
            if (direction == direction2) {
                double d3 = (double)(d2 > d ? -1 : 1) * 1.5 * 12.0;
                Point2D.Double double_ = new Point2D.Double(point2D4.getX() + d3, point2D4.getY());
                Snake snake = new Snake(this.arrowHorizontalAlignment(), this.myArrowColor);
                double d4 = (point2D3.getY() + point2D4.getY()) / 2.0;
                snake.addPoint(point2D3);
                snake.addPoint(point2D3.getX(), d4);
                snake.addPoint(((Point2D)double_).getX(), d4);
                snake.addPoint(double_);
                snake.goUnmergeable(MergeStrategy.LIMITED);
                uGraphic.draw(snake);
                Snake snake2 = new Snake(this.arrowHorizontalAlignment(), this.myArrowColor, uPolygon);
                snake2.addPoint(double_);
                snake2.addPoint(((Point2D)double_).getX(), point2D4.getY());
                snake2.addPoint(point2D4);
                snake2.goUnmergeable(MergeStrategy.LIMITED);
                uGraphic.draw(snake2);
            } else {
                double d5 = (double)(d2 > d ? -1 : 1) * 1.5 * 12.0;
                Point2D.Double double_ = new Point2D.Double(point2D4.getX() + d5, point2D4.getY() - 18.0);
                Snake snake = new Snake(this.arrowHorizontalAlignment(), this.myArrowColor);
                snake.addPoint(point2D3);
                snake.addPoint(point2D3.getX(), ((Point2D)double_).getY());
                snake.addPoint(double_);
                snake.goUnmergeable(MergeStrategy.LIMITED);
                uGraphic.draw(snake);
                Snake snake3 = new Snake(this.arrowHorizontalAlignment(), this.myArrowColor, uPolygon);
                snake3.addPoint(double_);
                snake3.addPoint(((Point2D)double_).getX(), point2D4.getY());
                snake3.addPoint(point2D4);
                snake3.goUnmergeable(MergeStrategy.LIMITED);
                uGraphic.draw(snake3);
            }
        }
    }

    class ConnectionHorizontalThenVertical
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow color;
        private final UPolygon usingArrow;

        public ConnectionHorizontalThenVertical(Ftile ftile, Branch branch) {
            super(FtileIfWithLinks.this.diamond1, ftile);
            this.color = FtileIfWithLinks.getInColor(branch, FtileIfWithLinks.this.arrowColor);
            if (this.color.size() == 0) {
                FtileIfWithLinks.getInColor(branch, FtileIfWithLinks.this.arrowColor);
                throw new IllegalArgumentException();
            }
            this.usingArrow = branch.isEmpty() ? null : Arrows.asToDown();
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            double d = point2D.getX();
            double d2 = point2D.getY();
            double d3 = point2D2.getX();
            double d4 = point2D2.getY();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.color, this.usingArrow);
            snake.addPoint(d, d2);
            snake.addPoint(d3, d2);
            snake.addPoint(d3, d4);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            double d;
            FtileGeometry ftileGeometry = FtileIfWithLinks.this.diamond1.calculateDimension(stringBounder);
            double d2 = ftileGeometry.getWidth();
            if (this.getFtile2() == FtileIfWithLinks.this.tile1) {
                d = 0.0;
            } else if (this.getFtile2() == FtileIfWithLinks.this.tile2) {
                d = d2;
            } else {
                throw new IllegalStateException();
            }
            double d3 = (ftileGeometry.getOutY() - ftileGeometry.getInY()) / 2.0;
            return FtileIfWithLinks.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(d, ftileGeometry.getInY() + d3));
        }

        private Point2D getP2(StringBounder stringBounder) {
            return this.translate(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }

        private UTranslate translate(StringBounder stringBounder) {
            if (this.getFtile2() == FtileIfWithLinks.this.tile1) {
                return FtileIfWithLinks.this.getTranslate1(stringBounder);
            }
            if (this.getFtile2() == FtileIfWithLinks.this.tile2) {
                return FtileIfWithLinks.this.getTranslate2(stringBounder);
            }
            throw new IllegalStateException();
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            Direction direction;
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Direction direction2 = Direction.leftOrRight(point2D, point2D2);
            if (direction2 != (direction = Direction.leftOrRight(point2D = uTranslate.getTranslated(point2D), point2D2 = uTranslate2.getTranslated(point2D2)))) {
                double d = (double)(direction2 == Direction.RIGHT ? -1 : 1) * 12.0;
                FtileGeometry ftileGeometry = FtileIfWithLinks.this.diamond1.calculateDimension(stringBounder);
                Snake snake = new Snake(this.arrowHorizontalAlignment(), this.color);
                snake.addPoint(point2D);
                snake.addPoint(point2D.getX() + d, point2D.getY());
                snake.addPoint(point2D.getX() + d, point2D.getY() + ((Dimension2D)ftileGeometry).getHeight() * 0.75);
                uGraphic.draw(snake);
                point2D = snake.getLast();
            }
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.color, this.usingArrow);
            snake.addPoint(point2D);
            snake.addPoint(point2D2.getX(), point2D.getY());
            snake.addPoint(point2D2);
            snake.goUnmergeable(MergeStrategy.LIMITED);
            uGraphic.draw(snake);
        }
    }
}

