/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.asciiart;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.asciiart.BasicCharArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicCharAreaImpl
implements BasicCharArea {
    private int charSize1 = 160;
    private int charSize2 = 160;
    private int width;
    private int height;
    private char[][] chars = new char[this.charSize1][this.charSize2];

    public BasicCharAreaImpl() {
        for (int i = 0; i < this.charSize1; ++i) {
            for (int j = 0; j < this.charSize2; ++j) {
                this.chars[i][j] = 32;
            }
        }
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public void drawChar(char c, int n, int n2) {
        this.ensurePossible(n, n2);
        this.chars[n][n2] = c;
        if (n >= this.width) {
            this.width = n + 1;
        }
        if (n2 >= this.height) {
            this.height = n2 + 1;
        }
    }

    private void ensurePossible(int n, int n2) {
        int n3;
        int n4 = this.charSize2;
        for (n3 = this.charSize1; n >= n3; n3 *= 2) {
        }
        while (n2 >= n4) {
            n4 *= 2;
        }
        if (n3 != this.charSize1 || n4 != this.charSize2) {
            char[][] cArray = new char[n3][n4];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    int n5 = 32;
                    if (i < this.charSize1 && j < this.charSize2) {
                        n5 = this.chars[i][j];
                    }
                    cArray[i][j] = n5;
                }
            }
            this.chars = cArray;
            this.charSize1 = n3;
            this.charSize2 = n4;
        }
    }

    @Override
    public void drawStringLR(String string, int n, int n2) {
        for (int i = 0; i < string.length(); ++i) {
            this.drawChar(string.charAt(i), n + i, n2);
        }
    }

    @Override
    public void drawStringTB(String string, int n, int n2) {
        for (int i = 0; i < string.length(); ++i) {
            this.drawChar(string.charAt(i), n, n2 + i);
        }
    }

    @Override
    public String getLine(int n) {
        StringBuilder stringBuilder = new StringBuilder(this.charSize1);
        for (int i = 0; i < this.width; ++i) {
            stringBuilder.append(this.chars[i][n]);
        }
        return stringBuilder.toString();
    }

    @Override
    public void print(PrintStream printStream) {
        for (String string : this.getLines()) {
            printStream.println(string);
        }
    }

    @Override
    public List<String> getLines() {
        ArrayList<String> arrayList = new ArrayList<String>(this.height);
        for (int i = 0; i < this.height; ++i) {
            arrayList.add(this.getLine(i));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public void drawHLine(char c, int n, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            this.drawChar(c, i, n);
        }
    }

    @Override
    public void drawHLine(char c, int n, int n2, int n3, char c2, char c3) {
        for (int i = n2; i < n3; ++i) {
            this.ensurePossible(i, n);
            if (this.chars[i][n] == c2) {
                this.drawChar(c3, i, n);
                continue;
            }
            this.drawChar(c, i, n);
        }
    }

    @Override
    public void drawVLine(char c, int n, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            this.drawChar(c, n, i);
        }
    }

    public String toString() {
        return this.getLines().toString();
    }

    @Override
    public void fillRect(char c, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                this.drawChar(c, n + i, n2 + j);
            }
        }
    }
}

