/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandControl;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.core.Diagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandMultilines2<S extends Diagram>
implements Command<S> {
    private final RegexConcat starting;
    private final MultilinesStrategy strategy;

    public CommandMultilines2(RegexConcat regexConcat, MultilinesStrategy multilinesStrategy) {
        if (!regexConcat.getPattern().startsWith("^") || !regexConcat.getPattern().endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + regexConcat.getPattern());
        }
        this.strategy = multilinesStrategy;
        this.starting = regexConcat;
    }

    public abstract String getPatternEnd();

    @Override
    public String[] getDescription() {
        return new String[]{"START: " + this.starting.getPattern(), "END: " + this.getPatternEnd()};
    }

    @Override
    public final CommandControl isValid(BlocLines blocLines) {
        blocLines = blocLines.cleanList2(this.strategy);
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        boolean bl = this.starting.match(StringUtils.trin(blocLines.getFirst499()));
        if (!bl) {
            return CommandControl.NOT_OK;
        }
        if (blocLines.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        Matcher2 matcher2 = MyPattern.cmpile(this.getPatternEnd()).matcher(StringUtils.trinNoTrace(blocLines.getLast499()));
        if (!matcher2.matches()) {
            return CommandControl.OK_PARTIAL;
        }
        this.actionIfCommandValid();
        return CommandControl.OK;
    }

    @Override
    public final CommandExecutionResult execute(S s2, BlocLines blocLines) {
        blocLines = blocLines.cleanList2(this.strategy);
        return this.executeNow(s2, blocLines);
    }

    public abstract CommandExecutionResult executeNow(S var1, BlocLines var2);

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    protected final RegexConcat getStartingPattern() {
        return this.starting;
    }
}

