/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Code;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.utils.UniqueSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandPackage
extends SingleLineCommand2<AbstractEntityDiagram> {
    public CommandPackage() {
        super(CommandPackage.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(package|together)"), new RegexLeaf("[%s]+"), new RegexLeaf("NAME", "([%g][^%g]+[%g]|[^#%s{}]*)"), new RegexLeaf("AS", "(?:[%s]+as[%s]+([\\p{L}0-9_.]+))?"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), CommandPackage.color().getRegex(), new RegexLeaf("[%s]*\\{$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractEntityDiagram abstractEntityDiagram, RegexResult regexResult) {
        Object object;
        Object object2;
        String string;
        Code code;
        String string2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("NAME", 0));
        if (regexResult.get("AS", 0) == null) {
            if (string2.length() == 0) {
                code = Code.of("##" + UniqueSequence.getValue());
                string = null;
            } else {
                code = Code.of(string2);
                string = code.getFullName();
            }
        } else {
            string = string2;
            code = Code.of(regexResult.get("AS", 0));
        }
        IGroup iGroup = abstractEntityDiagram.getCurrentGroup();
        IGroup iGroup2 = abstractEntityDiagram.getOrCreateGroup(code, Display.getWithNewlines(string), GroupType.PACKAGE, iGroup);
        String string3 = regexResult.get("STEREOTYPE", 0);
        USymbol uSymbol = USymbol.getFromString(regexResult.get("TYPE", 0));
        if (uSymbol == USymbol.TOGETHER) {
            iGroup2.setUSymbol(uSymbol);
        } else if (string3 != null) {
            object2 = USymbol.getFromString(string3);
            if (object2 == null) {
                iGroup2.setStereotype(new Stereotype(string3));
            } else {
                iGroup2.setUSymbol((USymbol)object2);
            }
        }
        object2 = regexResult.get("URL", 0);
        if (object2 != null) {
            object = new UrlBuilder(abstractEntityDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = ((UrlBuilder)object).getUrl((String)object2);
            iGroup2.addUrl(url);
        }
        object = CommandPackage.color().getColor(regexResult, abstractEntityDiagram.getSkinParam().getIHtmlColorSet());
        iGroup2.setColors((Colors)object);
        return CommandExecutionResult.ok();
    }
}

