/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandControl;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectedCommand<S extends Diagram>
implements Command<S> {
    private final Command<S> cmd;

    public ProtectedCommand(Command<S> command) {
        this.cmd = command;
    }

    @Override
    public CommandExecutionResult execute(S s2, BlocLines blocLines) {
        try {
            CommandExecutionResult commandExecutionResult = this.cmd.execute(s2, blocLines);
            return commandExecutionResult;
        }
        catch (Throwable throwable) {
            Log.error("Error " + throwable);
            throwable.printStackTrace();
            String string = "You should send a mail to plantuml@gmail.com or post to http://plantuml.com/qa with this log (V" + Version.versionString() + ")";
            Log.error(string);
            string = string + " " + throwable.toString();
            return CommandExecutionResult.error(string, throwable);
        }
    }

    @Override
    public CommandControl isValid(BlocLines blocLines) {
        return this.cmd.isValid(blocLines);
    }

    @Override
    public String[] getDescription() {
        return this.cmd.getDescription();
    }
}

