/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import java.util.List;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandControl;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.core.Diagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleLineCommand<S extends Diagram>
implements Command<S> {
    private final Pattern2 pattern;

    public SingleLineCommand(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (!string.startsWith("(?i)^") || !string.endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + string);
        }
        this.pattern = MyPattern.cmpile(string);
    }

    @Override
    public String[] getDescription() {
        return new String[]{this.pattern.pattern()};
    }

    @Override
    public final CommandControl isValid(BlocLines blocLines) {
        if (blocLines.size() != 1) {
            return CommandControl.NOT_OK;
        }
        blocLines = blocLines.removeInnerComments();
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        String string = StringUtils.trin(blocLines.getFirst499());
        Matcher2 matcher2 = this.pattern.matcher(string);
        boolean bl = matcher2.find();
        if (bl) {
            this.actionIfCommandValid();
        }
        return bl ? CommandControl.OK : CommandControl.NOT_OK;
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    @Override
    public final CommandExecutionResult execute(S s2, BlocLines blocLines) {
        if (blocLines.size() != 1) {
            throw new IllegalArgumentException();
        }
        String string = StringUtils.trin((blocLines = blocLines.removeInnerComments()).getFirst499());
        if (this.isForbidden(string)) {
            return CommandExecutionResult.error("Syntax error: " + string);
        }
        List<String> list = this.getSplit(string);
        if (list == null) {
            return CommandExecutionResult.error("Cannot parse line " + string);
        }
        return this.executeArg(s2, list);
    }

    protected boolean isForbidden(String string) {
        return false;
    }

    protected abstract CommandExecutionResult executeArg(S var1, List<String> var2);

    public final List<String> getSplit(String string) {
        return StringUtils.getSplit(this.pattern, string);
    }
}

