/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import znaishaded.net.sourceforge.plantuml.geom.Orientation;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;

public class Neighborhood {
    private final double angle1;
    private final double angle2;
    private final Point2DInt center;

    public Neighborhood(Point2DInt point2DInt) {
        this(point2DInt, 0.0, 0.0);
    }

    public boolean is360() {
        return this.angle1 == this.angle2;
    }

    public Neighborhood(Point2DInt point2DInt, double d, double d2) {
        this.center = point2DInt;
        this.angle1 = d;
        this.angle2 = d2;
    }

    public String toString() {
        int n = (int)(this.angle1 * 180.0 / Math.PI);
        int n2 = (int)(this.angle2 * 180.0 / Math.PI);
        return this.center + " " + n + " " + n2;
    }

    public final Point2DInt getCenter() {
        return this.center;
    }

    public final double getMiddle() {
        if (this.is360()) {
            return this.angle1 + Math.PI;
        }
        double d = (this.angle1 + this.angle2) / 2.0;
        if (this.angle2 < this.angle1) {
            d += Math.PI;
        }
        return d;
    }

    public boolean isInAngleStrict(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.angle2 > this.angle1) {
            return d > this.angle1 && d < this.angle2;
        }
        return d > this.angle1 || d < this.angle2;
    }

    public boolean isInAngleLarge(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.angle2 > this.angle1) {
            return d >= this.angle1 && d <= this.angle2;
        }
        return d >= this.angle1 || d <= this.angle2;
    }

    public boolean isAngleLimit(double d) {
        return d == this.angle1 || d == this.angle2;
    }

    public Orientation getOrientationFrom(double d) {
        if (this.angle1 == this.angle2) {
            throw new IllegalStateException();
        }
        if (d != this.angle1 && d != this.angle2) {
            throw new IllegalArgumentException("this=" + this + " angle=" + (int)(d * 180.0 / Math.PI));
        }
        assert (d == this.angle1 || d == this.angle2);
        if (d == this.angle1) {
            return Orientation.MATH;
        }
        return Orientation.CLOCK;
    }
}

