/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.graph.SortedCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedCollectionArrayList<S extends Comparable<S>>
implements SortedCollection<S> {
    private final List<S> allAsList = new ArrayList<S>();
    private final Set<S> allAsSet = new HashSet<S>();

    @Override
    public Iterator<S> iterator() {
        return this.allAsList.iterator();
    }

    @Override
    public void add(S s2) {
        int n = Collections.binarySearch(this.allAsList, s2);
        if (n >= 0) {
            this.allAsList.add(n, s2);
        } else {
            this.allAsList.add(-1 - n, s2);
        }
        this.allAsSet.add(s2);
        assert (this.isSorted());
    }

    @Override
    public int size() {
        assert (this.allAsSet.size() == this.allAsList.size());
        return this.allAsList.size();
    }

    List<S> toList() {
        return new ArrayList<S>(this.allAsList);
    }

    boolean isSorted() {
        Comparable comparable = null;
        for (Comparable comparable2 : this.allAsList) {
            if (comparable != null && comparable2.compareTo(comparable) < 0) {
                return false;
            }
            comparable = comparable2;
        }
        return true;
    }

    @Override
    public boolean contains(S s2) {
        return this.allAsSet.contains(s2);
    }
}

