/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.CompressionTransform;
import znaishaded.net.sourceforge.plantuml.ugraphic.SlotFinder;
import znaishaded.net.sourceforge.plantuml.ugraphic.SlotSet;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphicCompress;

public class TextBlockCompressed
extends AbstractTextBlock
implements TextBlock {
    private final TextBlock textBlock;

    public TextBlockCompressed(TextBlock textBlock) {
        this.textBlock = textBlock;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        CompressionTransform compressionTransform = this.getCompressionTransform(stringBounder);
        this.textBlock.drawU(new UGraphicCompress(uGraphic, compressionTransform));
    }

    private CompressionTransform getCompressionTransform(StringBounder stringBounder) {
        SlotFinder slotFinder = new SlotFinder(stringBounder);
        this.textBlock.drawU(slotFinder);
        SlotSet slotSet = slotFinder.getYSlotSet().reverse().smaller(5.0);
        CompressionTransform compressionTransform = new CompressionTransform(slotSet);
        return compressionTransform;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        CompressionTransform compressionTransform = this.getCompressionTransform(stringBounder);
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        return new Dimension2DDouble(dimension2D.getWidth(), compressionTransform.transform(dimension2D.getHeight()));
    }
}

