/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBlockHorizontal
extends AbstractTextBlock
implements TextBlock {
    private final List<TextBlock> blocks = new ArrayList<TextBlock>();
    private final VerticalAlignment alignment;

    TextBlockHorizontal(TextBlock textBlock, TextBlock textBlock2, VerticalAlignment verticalAlignment) {
        this.blocks.add(textBlock);
        this.blocks.add(textBlock2);
        this.alignment = verticalAlignment;
    }

    public TextBlockHorizontal(List<TextBlock> list, VerticalAlignment verticalAlignment) {
        if (list.size() < 2) {
            throw new IllegalArgumentException();
        }
        this.blocks.addAll(list);
        this.alignment = verticalAlignment;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.blocks.get(0).calculateDimension(stringBounder);
        for (int i = 1; i < this.blocks.size(); ++i) {
            dimension2D = Dimension2DDouble.mergeLR(dimension2D, this.blocks.get(i).calculateDimension(stringBounder));
        }
        return dimension2D;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        double d = 0.0;
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        for (TextBlock textBlock : this.blocks) {
            Dimension2D dimension2D2 = textBlock.calculateDimension(uGraphic.getStringBounder());
            if (this.alignment == VerticalAlignment.CENTER) {
                double d2 = (dimension2D.getHeight() - dimension2D2.getHeight()) / 2.0;
                textBlock.drawU(uGraphic.apply(new UTranslate(d, d2)));
            } else {
                textBlock.drawU(uGraphic.apply(new UTranslate(d, 0.0)));
            }
            d += dimension2D2.getWidth();
        }
    }
}

