/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.jdot;

import h.Agedge_s;
import h.Agedgeinfo_t;
import h.bezier;
import h.splines;
import h.textlabel_t;
import java.awt.geom.Point2D;
import smetana.core.Macro;
import smetana.core.__ptr__;
import smetana.core.__struct__;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.jdot.YMirror;
import znaishaded.net.sourceforge.plantuml.posimo.DotPath;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class JDotPath
implements UDrawable {
    private final Link link;
    private final Agedge_s edge;
    private final YMirror ymirror;
    private final CucaDiagram diagram;
    private final TextBlock label;
    private final Rose rose = new Rose();

    public JDotPath(Link link, Agedge_s agedge_s, YMirror yMirror, CucaDiagram cucaDiagram, TextBlock textBlock) {
        this.link = link;
        this.edge = agedge_s;
        this.ymirror = yMirror;
        this.diagram = cucaDiagram;
        this.label = textBlock;
    }

    private ColorParam getArrowColorParam() {
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.CLASS) {
            return ColorParam.arrow;
        }
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.OBJECT) {
            return ColorParam.arrow;
        }
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.DESCRIPTION) {
            return ColorParam.arrow;
        }
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            return ColorParam.arrow;
        }
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.STATE) {
            return ColorParam.arrow;
        }
        throw new IllegalStateException();
    }

    public void drawU(UGraphic uGraphic) {
        Object object;
        Object object2 = this.rose.getHtmlColor(this.diagram.getSkinParam(), this.getArrowColorParam(), null);
        if (this.link.getColors() != null) {
            object = this.link.getColors().getColor(ColorType.ARROW, ColorType.LINE);
            if (object != null) {
                object2 = object;
            }
        } else if (this.link.getSpecificColor() != null) {
            object2 = this.link.getSpecificColor();
        }
        object = this.getDotPath(this.edge);
        if (this.ymirror != null && object != null) {
            object = this.ymirror.getMirrored((DotPath)object);
        }
        if (object != null) {
            uGraphic.apply(new UChangeColor((HtmlColor)object2)).draw((UShape)object);
        }
        if (this.getLabelRectangleTranslate() != null) {
            this.label.drawU(uGraphic.apply(this.getLabelRectangleTranslate()));
        }
    }

    private void printDebug(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLUE)).apply(new UChangeBackColor(HtmlColorUtils.BLUE));
        splines splines2 = this.getSplines(this.edge);
        bezier bezier2 = (bezier)splines2.getPtr("list");
        for (int i = 0; i < bezier2.getInt("size"); ++i) {
            Point2D point2D = this.getPoint(splines2, i);
            if (this.ymirror != null) {
                point2D = this.ymirror.getMirrored(point2D);
            }
            uGraphic.apply(new UTranslate(point2D).compose(new UTranslate(-1.0, -1.0))).draw(new UEllipse(3.0, 3.0));
        }
        if (this.getLabelRectangleTranslate() != null && this.getLabelURectangle() != null) {
            uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLUE)).apply(new UChangeBackColor(null));
            uGraphic.apply(this.getLabelRectangleTranslate()).draw(this.getLabelURectangle());
        }
    }

    private URectangle getLabelURectangle() {
        Agedgeinfo_t agedgeinfo_t = (Agedgeinfo_t)Macro.AGDATA(this.edge).castTo(Agedgeinfo_t.class);
        textlabel_t textlabel_t2 = (textlabel_t)agedgeinfo_t.getPtr("label");
        if (textlabel_t2 == null) {
            return null;
        }
        __struct__ __struct__2 = textlabel_t2.getStruct("dimen");
        __struct__ __struct__3 = textlabel_t2.getStruct("space");
        __struct__ __struct__4 = textlabel_t2.getStruct("pos");
        double d = __struct__4.getDouble("x");
        double d2 = __struct__4.getDouble("y");
        double d3 = __struct__2.getDouble("x");
        double d4 = __struct__2.getDouble("y");
        return new URectangle(d3, d4);
    }

    private UTranslate getLabelRectangleTranslate() {
        Agedgeinfo_t agedgeinfo_t = (Agedgeinfo_t)Macro.AGDATA(this.edge).castTo(Agedgeinfo_t.class);
        textlabel_t textlabel_t2 = (textlabel_t)agedgeinfo_t.getPtr("label");
        if (textlabel_t2 == null) {
            return null;
        }
        __struct__ __struct__2 = textlabel_t2.getStruct("dimen");
        __struct__ __struct__3 = textlabel_t2.getStruct("space");
        __struct__ __struct__4 = textlabel_t2.getStruct("pos");
        double d = __struct__4.getDouble("x");
        double d2 = __struct__4.getDouble("y");
        double d3 = __struct__2.getDouble("x");
        double d4 = __struct__2.getDouble("y");
        if (this.ymirror == null) {
            return new UTranslate(d - d3 / 2.0, d2 - d4 / 2.0);
        }
        return this.ymirror.getMirrored(new UTranslate(d - d3 / 2.0, d2 + d4 / 2.0));
    }

    public DotPath getDotPath(Agedge_s agedge_s) {
        splines splines2 = this.getSplines(agedge_s);
        return this.getDotPath(splines2);
    }

    private splines getSplines(Agedge_s agedge_s) {
        Agedgeinfo_t agedgeinfo_t = (Agedgeinfo_t)Macro.AGDATA(agedge_s).castTo(Agedgeinfo_t.class);
        splines splines2 = (splines)agedgeinfo_t.getPtr("spl");
        return splines2;
    }

    private DotPath getDotPath(splines splines2) {
        if (splines2 == null) {
            System.err.println("ERROR, no splines for getDotPath");
            return null;
        }
        DotPath dotPath = new DotPath();
        bezier bezier2 = (bezier)splines2.getPtr("list");
        Point2D point2D = this.getPoint(splines2, 0);
        Point2D point2D2 = this.getPoint(splines2, 1);
        Point2D point2D3 = this.getPoint(splines2, 2);
        Point2D point2D4 = this.getPoint(splines2, 3);
        dotPath = dotPath.addCurve(point2D, point2D2, point2D3, point2D4);
        int n = bezier2.getInt("size");
        for (int i = 4; i < n; i += 3) {
            Point2D point2D5 = this.getPoint(splines2, i);
            Point2D point2D6 = this.getPoint(splines2, i + 1);
            Point2D point2D7 = this.getPoint(splines2, i + 2);
            dotPath = dotPath.addCurve(point2D5, point2D6, point2D7);
        }
        return dotPath;
    }

    private Point2D getPoint(splines splines2, int n) {
        bezier bezier2 = (bezier)splines2.getPtr("list");
        __ptr__ __ptr__2 = bezier2.getPtr("list").plus(n).getPtr();
        return new Point2D.Double(__ptr__2.getDouble("x"), __ptr__2.getDouble("y"));
    }
}

