/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.png;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Metadata {
    public static void main(String[] stringArray) throws IOException {
        Metadata metadata = new Metadata();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            metadata.readAndDisplayMetadata(new File(stringArray[i]));
        }
    }

    public void readAndDisplayMetadata(File file) throws IOException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            imageReader.setInput(imageInputStream, true);
            IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
            String[] stringArray = iIOMetadata.getMetadataFormatNames();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.displayMetadata(iIOMetadata.getAsTree(stringArray[i]));
            }
        }
    }

    private void displayMetadata(Node node) {
        this.displayMetadata(node, 0);
    }

    private void indent(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("    ");
        }
    }

    private void displayMetadata(Node node, int n) {
        Node node2;
        this.indent(n);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n2 = namedNodeMap.getLength();
            for (int i = 0; i < n2; ++i) {
                Node node3 = namedNodeMap.item(i);
                System.out.print(" " + node3.getNodeName() + "=\"" + node3.getNodeValue() + "\"");
            }
        }
        if ((node2 = node.getFirstChild()) == null) {
            System.out.println("/>");
            return;
        }
        System.out.println(">");
        while (node2 != null) {
            this.displayMetadata(node2, n + 1);
            node2 = node2.getNextSibling();
        }
        this.indent(n);
        System.out.println("</" + node.getNodeName() + ">");
    }
}

