/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.preproc;

import znaishaded.net.sourceforge.plantuml.preproc.Truth;

public class EvalBoolean {
    private final String str;
    private int pos = -1;
    private char ch;
    private final Truth truth;

    public EvalBoolean(String string, Truth truth) {
        this.str = string;
        this.truth = truth;
    }

    private void nextChar() {
        ++this.pos;
        this.ch = this.pos < this.str.length() ? this.str.charAt(this.pos) : (char)'\u0000';
    }

    private boolean eat(char c) {
        while (this.ch == ' ') {
            this.nextChar();
        }
        if (this.ch == c) {
            this.nextChar();
            return true;
        }
        return false;
    }

    private boolean parseExpression() {
        boolean bl = this.parseTerm();
        while (this.eat('|')) {
            this.eat('|');
            bl |= this.parseTerm();
        }
        return bl;
    }

    private boolean parseTerm() {
        boolean bl = this.parseFactor();
        while (this.eat('&')) {
            this.eat('&');
            bl &= this.parseFactor();
        }
        return bl;
    }

    private boolean parseFactor() {
        boolean bl;
        if (this.eat('!')) {
            return !this.parseFactor();
        }
        int n = this.pos;
        if (this.eat('(')) {
            bl = this.parseExpression();
            this.eat(')');
        } else if (this.isIdentifier()) {
            while (this.isIdentifier()) {
                this.nextChar();
            }
            String string = this.str.substring(n, this.pos);
            bl = this.truth.isTrue(string);
        } else {
            throw new IllegalArgumentException("Unexpected: " + this.ch);
        }
        return bl;
    }

    private boolean isIdentifier() {
        return this.ch == '_' || Character.isLetterOrDigit(this.ch);
    }

    public boolean eval() {
        this.nextChar();
        boolean bl = this.parseExpression();
        if (this.pos < this.str.length()) {
            throw new IllegalArgumentException("Unexpected: " + this.ch);
        }
        return bl;
    }
}

