/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.CharSequence2;
import znaishaded.net.sourceforge.plantuml.CharSequence2Impl;
import znaishaded.net.sourceforge.plantuml.DefinitionsContainer;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.preproc.Defines;
import znaishaded.net.sourceforge.plantuml.preproc.FileWithSuffix;
import znaishaded.net.sourceforge.plantuml.preproc.IfManager;
import znaishaded.net.sourceforge.plantuml.preproc.PreprocessorInclude;
import znaishaded.net.sourceforge.plantuml.preproc.ReadLine;
import znaishaded.net.sourceforge.plantuml.preproc.ReadLineInsertable;
import znaishaded.net.sourceforge.plantuml.utils.StartUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preprocessor
implements ReadLine {
    private static final String END_DEFINE_LONG = "!enddefinelong";
    private static final String ID = "[A-Za-z_][A-Za-z_0-9]*";
    private static final String ID_ARG = "\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?";
    private static final String ARG = "(?:\\(\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?(?:,\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?)*?\\))?";
    private static final Pattern2 definePattern = MyPattern.cmpile("^[%s]*!define[%s]+([A-Za-z_][A-Za-z_0-9]*(?:\\(\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?(?:,\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?)*?\\))?)(?:[%s]+(.*))?$");
    private static final Pattern2 undefPattern = MyPattern.cmpile("^[%s]*!undef[%s]+([A-Za-z_][A-Za-z_0-9]*)$");
    private static final Pattern2 definelongPattern = MyPattern.cmpile("^[%s]*!definelong[%s]+([A-Za-z_][A-Za-z_0-9]*(?:\\(\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?(?:,\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?)*?\\))?)");
    private static final Pattern2 enddefinelongPattern = MyPattern.cmpile("^[%s]*!enddefinelong[%s]*$");
    private final Defines defines;
    private final PreprocessorInclude rawSource;
    private final ReadLineInsertable source;
    private int ignoreDefineDuringSeveralLines = 0;

    public Preprocessor(ReadLine readLine, String string, Defines defines, File file, DefinitionsContainer definitionsContainer) {
        this.defines = defines;
        this.defines.saveState();
        this.rawSource = new PreprocessorInclude(readLine, defines, string, file, definitionsContainer);
        this.source = new ReadLineInsertable(new IfManager(this.rawSource, defines));
    }

    @Override
    public CharSequence2 readLine() throws IOException {
        Matcher2 matcher2;
        CharSequence2 charSequence2 = this.source.readLine();
        if (charSequence2 == null) {
            return null;
        }
        if (StartUtils.isArobaseStartDiagram(charSequence2)) {
            this.defines.restoreState();
        }
        if ((matcher2 = definePattern.matcher(charSequence2)).find()) {
            return this.manageDefine(matcher2, charSequence2.toString().trim().endsWith("()"));
        }
        matcher2 = definelongPattern.matcher(charSequence2);
        if (matcher2.find()) {
            return this.manageDefineLong(matcher2, charSequence2.toString().trim().endsWith("()"));
        }
        matcher2 = undefPattern.matcher(charSequence2);
        if (matcher2.find()) {
            return this.manageUndef(matcher2);
        }
        if (this.ignoreDefineDuringSeveralLines > 0) {
            --this.ignoreDefineDuringSeveralLines;
            return charSequence2;
        }
        List<String> list = this.defines.applyDefines(charSequence2.toString2());
        if (list.size() > 1) {
            list = this.cleanEndDefineLong(list);
            List<String> list2 = this.cleanEndDefineLong(list.subList(1, list.size()));
            this.ignoreDefineDuringSeveralLines = list2.size();
            this.source.insert(list2, charSequence2.getLocation());
        }
        return new CharSequence2Impl(list.get(0), charSequence2.getLocation(), charSequence2.getPreprocessorError());
    }

    private List<String> cleanEndDefineLong(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = this.cleanEndDefineLong(string);
            if (string2 == null) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private String cleanEndDefineLong(String string) {
        if (string.trim().startsWith(END_DEFINE_LONG) && (string = string.trim().substring(END_DEFINE_LONG.length())).length() == 0) {
            return null;
        }
        return string;
    }

    private CharSequence2 manageUndef(Matcher2 matcher2) throws IOException {
        this.defines.undefine(matcher2.group(1));
        return this.readLine();
    }

    private CharSequence2 manageDefineLong(Matcher2 matcher2, boolean bl) throws IOException {
        CharSequence2 charSequence2;
        String string = matcher2.group(1);
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            if ((charSequence2 = this.readLine()) == null) {
                return null;
            }
            arrayList.add(charSequence2.toString2());
        } while (!enddefinelongPattern.matcher(charSequence2).find());
        this.defines.define(string, arrayList, bl);
        return this.readLine();
    }

    private CharSequence2 manageDefine(Matcher2 matcher2, boolean bl) throws IOException {
        String string = matcher2.group(1);
        String string2 = matcher2.group(2);
        if (string2 == null) {
            this.defines.define(string, null, bl);
        } else {
            List<String> list = this.defines.applyDefines(string2);
            if (list.size() > 1) {
                this.defines.define(string, list, bl);
            } else {
                Object object;
                StringBuilder stringBuilder = new StringBuilder(list.get(0));
                while (StringUtils.endsWithBackslash(stringBuilder.toString())) {
                    stringBuilder.setLength(stringBuilder.length() - 1);
                    object = this.readLine();
                    stringBuilder.append(object.toString2());
                }
                object = new ArrayList<String>();
                object.add(stringBuilder.toString());
                this.defines.define(string, (List<String>)object, bl);
            }
        }
        return this.readLine();
    }

    public int getLineNumber() {
        return this.rawSource.getLineNumber();
    }

    @Override
    public void close() throws IOException {
        this.rawSource.close();
    }

    public Set<FileWithSuffix> getFilesUsed() {
        return Collections.unmodifiableSet(this.rawSource.getFilesUsedGlobal());
    }
}

