/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.graphic;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.project.Item;
import znaishaded.net.sourceforge.plantuml.project.Project;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

class ItemHeader {
    private final UFont font = UFont.serif(9);
    private final Project project;
    private final FontConfiguration fontConfig = FontConfiguration.blackBlueTrue(this.font);

    public ItemHeader(Project project) {
        this.project = project;
    }

    public void draw(UGraphic uGraphic, double d, double d2) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK));
        uGraphic.apply(new UTranslate(d, d2)).draw(new URectangle(this.getWidth(stringBounder), this.getHeight(stringBounder)));
        for (Item item2 : this.project.getValidItems()) {
            TextBlock textBlock = Display.create("" + item2.getCode()).create(this.fontConfig, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
            textBlock.drawU(uGraphic.apply(new UTranslate(d, d2)));
            uGraphic.apply(new UTranslate(d, d2 += dimension2D.getHeight())).draw(new ULine(this.getWidth(stringBounder), 0.0));
        }
    }

    public double getWidth(StringBounder stringBounder) {
        double d = 0.0;
        for (Item item2 : this.project.getValidItems()) {
            Dimension2D dimension2D = stringBounder.calculateDimension(this.font, item2.getCode());
            d = Math.max(d, dimension2D.getWidth());
        }
        return d;
    }

    public double getHeight(StringBounder stringBounder) {
        double d = 0.0;
        for (Item item2 : this.project.getValidItems()) {
            Dimension2D dimension2D = stringBounder.calculateDimension(this.font, item2.getCode());
            d += dimension2D.getHeight();
        }
        return d;
    }

    public double getPosition(StringBounder stringBounder, Item item2) {
        double d = 0.0;
        for (Item item3 : this.project.getValidItems()) {
            if (item3 == item2) {
                return d;
            }
            Dimension2D dimension2D = stringBounder.calculateDimension(this.font, item3.getCode());
            d += dimension2D.getHeight();
        }
        throw new IllegalArgumentException();
    }
}

