/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.salt.element.AbstractElement;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

abstract class AbstractElementText
extends AbstractElement {
    private final TextBlock block;
    private final FontConfiguration config;
    private final int charLength;

    public AbstractElementText(String string, UFont uFont, boolean bl, ISkinSimple iSkinSimple) {
        this.config = FontConfiguration.blackBlueTrue(uFont);
        if (bl) {
            this.charLength = this.getCharNumber(string);
            string = StringUtils.trin(string);
        } else {
            this.charLength = 0;
        }
        this.block = Display.create(string).create(this.config, HorizontalAlignment.LEFT, iSkinSimple);
    }

    private int getCharNumber(String string) {
        string = string.replaceAll("<&[-\\w]+>", "00");
        return string.length();
    }

    protected void drawText(UGraphic uGraphic, double d, double d2) {
        this.block.drawU(uGraphic.apply(new UTranslate(d, d2)));
    }

    protected Dimension2D getPureTextDimension(StringBounder stringBounder) {
        return this.block.calculateDimension(stringBounder);
    }

    protected Dimension2D getTextDimensionAt(StringBounder stringBounder, double d) {
        Dimension2D dimension2D = this.block.calculateDimension(stringBounder);
        if (this.charLength == 0) {
            return dimension2D;
        }
        double d2 = this.getSingleSpace(stringBounder);
        return new Dimension2DDouble(Math.max(dimension2D.getWidth(), (double)this.charLength * d2), dimension2D.getHeight());
    }

    private double getSingleSpace(StringBounder stringBounder) {
        return 8.0;
    }

    protected final FontConfiguration getConfig() {
        return this.config;
    }
}

