/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.Scale;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityPortion;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import znaishaded.net.sourceforge.plantuml.sequencediagram.AutoNumber;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Delay;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Divider;
import znaishaded.net.sourceforge.plantuml.sequencediagram.DottedNumber;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.EventWithDeactivate;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Grouping;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingStart;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.HSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.LifeEvent;
import znaishaded.net.sourceforge.plantuml.sequencediagram.LifeEventType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Message;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Newpage;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Note;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Notes;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import znaishaded.net.sourceforge.plantuml.sequencediagram.ParticipantType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Reference;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramFileMakerPuma2;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramTxtMaker;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.SequenceDiagramFileMakerTeoz;
import znaishaded.net.sourceforge.plantuml.skin.ProtectedSkin;
import znaishaded.net.sourceforge.plantuml.skin.Skin;
import znaishaded.net.sourceforge.plantuml.skin.SkinUtils;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceDiagram
extends UmlDiagram {
    private final Map<String, Participant> participants = new LinkedHashMap<String, Participant>();
    private final List<Event> events = new ArrayList<Event>();
    private final Map<Participant, ParticipantEnglober> participantEnglobers2 = new HashMap<Participant, ParticipantEnglober>();
    private final Skin skinInitial = new ProtectedSkin(new Rose());
    private Skin skin2 = new ProtectedSkin(new Rose());
    private EventWithDeactivate lastEventWithDeactivate;
    private boolean ignoreNewpage = false;
    private int autonewpage = -1;
    private Delay lastDelay;
    private final Stack<Message> activationState = new Stack();
    private LifeEvent pendingCreate = null;
    private final List<GroupingStart> openGroupings = new ArrayList<GroupingStart>();
    private final AutoNumber autoNumber = new AutoNumber();
    private boolean showFootbox = true;
    private ParticipantEnglober participantEnglober;
    private boolean autoactivate;
    private final Set<EntityPortion> hiddenPortions = EnumSet.noneOf(EntityPortion.class);

    @Deprecated
    public Participant getOrCreateParticipant(String string) {
        return this.getOrCreateParticipant(string, Display.getWithNewlines(string));
    }

    public Participant getOrCreateParticipant(String string, Display display) {
        Participant participant = this.participants.get(string);
        if (participant == null) {
            participant = new Participant(ParticipantType.PARTICIPANT, string, display, this.hiddenPortions);
            this.participants.put(string, participant);
            this.participantEnglobers2.put(participant, this.participantEnglober);
        }
        return participant;
    }

    public EventWithDeactivate getLastEventWithDeactivate() {
        return this.lastEventWithDeactivate;
    }

    public Participant createNewParticipant(ParticipantType participantType, String string, Display display) {
        if (this.participants.containsKey(string)) {
            throw new IllegalArgumentException();
        }
        if (Display.isNull(display)) {
            display = Display.getWithNewlines(string);
        }
        Participant participant = new Participant(participantType, string, display, this.hiddenPortions);
        this.participants.put(string, participant);
        this.participantEnglobers2.put(participant, this.participantEnglober);
        return participant;
    }

    public Map<String, Participant> participants() {
        return Collections.unmodifiableMap(this.participants);
    }

    public String addMessage(AbstractMessage abstractMessage) {
        this.lastEventWithDeactivate = abstractMessage;
        this.lastDelay = null;
        this.events.add(abstractMessage);
        if (this.pendingCreate != null) {
            if (!abstractMessage.compatibleForCreate(this.pendingCreate.getParticipant())) {
                return "After create command, you have to send a message to \"" + this.pendingCreate.getParticipant() + "\"";
            }
            abstractMessage.addLifeEvent(this.pendingCreate);
            this.pendingCreate = null;
        }
        return null;
    }

    public void addNote(Note note, boolean bl) {
        if (bl && this.events.size() > 0) {
            Event event = this.events.get(this.events.size() - 1);
            if (event instanceof Note) {
                Notes notes = new Notes((Note)event, note);
                this.events.set(this.events.size() - 1, notes);
                return;
            }
            if (event instanceof Notes) {
                ((Notes)event).add(note);
                return;
            }
        }
        this.events.add(note);
    }

    public void newpage(Display display) {
        if (this.ignoreNewpage) {
            return;
        }
        this.events.add(new Newpage(display));
    }

    public void ignoreNewpage() {
        this.ignoreNewpage = true;
    }

    public final int getAutonewpage() {
        return this.autonewpage;
    }

    public void setAutonewpage(int n) {
        this.autonewpage = n;
    }

    public void divider(Display display) {
        this.events.add(new Divider(display));
    }

    public void hspace() {
        this.events.add(new HSpace());
    }

    public void hspace(int n) {
        this.events.add(new HSpace(n));
    }

    public void delay(Display display) {
        Delay delay = new Delay(display);
        this.events.add(delay);
        this.lastDelay = delay;
    }

    public List<Event> events() {
        return Collections.unmodifiableList(this.events);
    }

    private FileMaker getSequenceDiagramPngMaker(FileFormatOption fileFormatOption) {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.ATXT || fileFormat == FileFormat.UTXT) {
            return new SequenceDiagramTxtMaker(this, fileFormat);
        }
        if (this.modeTeoz()) {
            return new SequenceDiagramFileMakerTeoz(this, this.getSkin2(), fileFormatOption);
        }
        return new SequenceDiagramFileMakerPuma2(this, this.getSkin2(), fileFormatOption);
    }

    private boolean modeTeoz() {
        return this.getPragma().useTeozLayout();
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        FileMaker fileMaker = this.getSequenceDiagramPngMaker(fileFormatOption);
        return fileMaker.createOne(outputStream, n, fileFormatOption.isWithMetadata());
    }

    public Message getActivatingMessage() {
        if (this.activationState.empty()) {
            return null;
        }
        return this.activationState.peek();
    }

    public String activate(Participant participant, LifeEventType lifeEventType, HtmlColor htmlColor) {
        return this.activate(participant, lifeEventType, htmlColor, null);
    }

    public String activate(Participant participant, LifeEventType lifeEventType, HtmlColor htmlColor, HtmlColor htmlColor2) {
        if (this.lastDelay != null) {
            return "You cannot Activate/Deactivate just after a ...";
        }
        LifeEvent lifeEvent = new LifeEvent(participant, lifeEventType, new SymbolContext(htmlColor, htmlColor2));
        this.events.add(lifeEvent);
        if (lifeEventType == LifeEventType.CREATE) {
            this.pendingCreate = lifeEvent;
            return null;
        }
        if (this.lastEventWithDeactivate == null) {
            if (lifeEventType == LifeEventType.ACTIVATE) {
                participant.incInitialLife(new SymbolContext(htmlColor, htmlColor2));
                return null;
            }
            return "Only activate command can occur before message are send";
        }
        if (lifeEventType == LifeEventType.ACTIVATE && this.lastEventWithDeactivate instanceof Message) {
            this.activationState.push((Message)this.lastEventWithDeactivate);
        } else if (lifeEventType == LifeEventType.DEACTIVATE && !this.activationState.empty()) {
            this.activationState.pop();
        }
        boolean bl = this.lastEventWithDeactivate.addLifeEvent(lifeEvent);
        if (this.lastEventWithDeactivate instanceof AbstractMessage) {
            lifeEvent.setMessage((AbstractMessage)this.lastEventWithDeactivate);
        }
        if (bl) {
            return null;
        }
        return "Activate/Deactivate already done on " + participant.getCode();
    }

    public boolean grouping(String string, String string2, GroupingType groupingType, HtmlColor htmlColor, HtmlColor htmlColor2) {
        if (groupingType != GroupingType.START && this.openGroupings.size() == 0) {
            return false;
        }
        if (htmlColor == null) {
            htmlColor = this.getSkinParam().getHtmlColor(ColorParam.sequenceGroupBodyBackground, null, false);
        }
        GroupingStart groupingStart = this.openGroupings.size() > 0 ? this.openGroupings.get(0) : null;
        Grouping grouping = groupingType == GroupingType.START ? new GroupingStart(string, string2, htmlColor, htmlColor2, groupingStart) : new GroupingLeaf(string, string2, groupingType, htmlColor, htmlColor2, groupingStart);
        this.events.add(grouping);
        if (groupingType == GroupingType.START) {
            this.openGroupings.add(0, (GroupingStart)grouping);
        } else if (groupingType == GroupingType.END) {
            this.openGroupings.remove(0);
            this.lastEventWithDeactivate = (GroupingLeaf)grouping;
        }
        return true;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(" + this.participants.size() + " participants)");
    }

    public boolean changeSkin(String string) {
        Skin skin = SkinUtils.loadSkin(string);
        Integer n = new Integer(1);
        if (skin != null && n.equals(skin.getProtocolVersion())) {
            this.skin2 = new ProtectedSkin(skin);
            return true;
        }
        return false;
    }

    private Skin getSkin2() {
        if (this.modeTeoz()) {
            return this.skinInitial;
        }
        return this.skin2;
    }

    public final void autonumberGo(DottedNumber dottedNumber, int n, DecimalFormat decimalFormat) {
        this.autoNumber.go(dottedNumber, n, decimalFormat);
    }

    public final void autonumberStop() {
        this.autoNumber.stop();
    }

    public final AutoNumber getAutoNumber() {
        return this.autoNumber;
    }

    public String getNextMessageNumber() {
        return this.autoNumber.getNextMessageNumber();
    }

    public boolean isShowFootbox() {
        if (this.getSkinParam().strictUmlStyle()) {
            return false;
        }
        String string = this.getSkinParam().getValue("footbox");
        if (string == null) {
            return this.showFootbox;
        }
        return !string.equalsIgnoreCase("hide");
    }

    public void setShowFootbox(boolean bl) {
        this.showFootbox = bl;
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.SEQUENCE;
    }

    public void boxStart(Display display, HtmlColor htmlColor) {
        if (this.participantEnglober != null) {
            throw new IllegalStateException();
        }
        this.participantEnglober = new ParticipantEnglober(display, htmlColor);
    }

    public void endBox() {
        if (this.participantEnglober == null) {
            throw new IllegalStateException();
        }
        this.participantEnglober = null;
    }

    public boolean isBoxPending() {
        return this.participantEnglober != null;
    }

    @Override
    public int getNbImages() {
        try {
            return this.getSequenceDiagramPngMaker(new FileFormatOption(FileFormat.PNG)).getNbPages();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 1;
        }
    }

    public void removeHiddenParticipants() {
        for (Participant participant : new ArrayList<Participant>(this.participants.values())) {
            if (!this.isAlone(participant)) continue;
            this.remove(participant);
        }
    }

    private void remove(Participant participant) {
        boolean bl = this.participants.values().remove(participant);
        if (!bl) {
            throw new IllegalArgumentException();
        }
        this.participantEnglobers2.remove(participant);
    }

    private boolean isAlone(Participant participant) {
        for (Event event : this.events) {
            if (!event.dealWith(participant)) continue;
            return false;
        }
        return true;
    }

    public void putParticipantInLast(String string) {
        Participant participant = this.participants.get(string);
        if (participant == null) {
            throw new IllegalArgumentException(string);
        }
        this.participants.remove(string);
        this.participants.put(string, participant);
        this.participantEnglobers2.put(participant, this.participantEnglober);
    }

    public ParticipantEnglober getEnglober(Participant participant) {
        return this.participantEnglobers2.get(participant);
    }

    public final void setAutoactivate(boolean bl) {
        this.autoactivate = bl;
    }

    public final boolean isAutoactivate() {
        return this.autoactivate;
    }

    @Override
    public boolean hasUrl() {
        for (Participant object : this.participants.values()) {
            if (object.getUrl() == null) continue;
            return true;
        }
        for (Event event : this.events) {
            if (!event.hasUrl()) continue;
            return true;
        }
        return !DisplayPositionned.isNull(this.getLegend()) && this.getLegend().hasUrl();
    }

    public void addReference(Reference reference) {
        this.events.add(reference);
    }

    @Override
    public boolean isOk() {
        return this.participants.size() != 0;
    }

    public double getDpiFactor(FileFormatOption fileFormatOption, Dimension2D dimension2D) {
        Scale scale = this.getScale();
        double d = scale == null ? this.getDpiFactor(fileFormatOption) : scale.getScale(dimension2D.getWidth(), dimension2D.getHeight());
        return d;
    }

    @Override
    public String checkFinalError() {
        if (this.isHideUnlinkedData()) {
            this.removeHiddenParticipants();
        }
        return super.checkFinalError();
    }

    public void hideOrShow(Set<EntityPortion> set, boolean bl) {
        if (bl) {
            this.hiddenPortions.removeAll(set);
        } else {
            this.hiddenPortions.addAll(set);
        }
    }
}

