/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamBackcolored;
import znaishaded.net.sourceforge.plantuml.SkinParamDelegator;
import znaishaded.net.sourceforge.plantuml.SkinParamForceColor;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.LifeSegmentVariation;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.Pushable;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.SegmentColored;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.Stairs;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Skin;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifeLine {
    private final Pushable participant;
    private final double nominalPreferredWidth;
    private final List<Variation> events = new ArrayList<Variation>();
    private final Stairs stairs = new Stairs();
    private int maxLevel = 0;
    private final boolean shadowing;
    private double create = 0.0;

    public LifeLine(Pushable pushable, double d, boolean bl) {
        this.participant = pushable;
        this.nominalPreferredWidth = d;
        this.shadowing = bl;
    }

    public void addSegmentVariation(LifeSegmentVariation lifeSegmentVariation, double d, SymbolContext symbolContext) {
        if (this.events.size() > 0) {
            Variation variation = this.events.get(this.events.size() - 1);
            if (d < variation.y) {
                return;
            }
            if (d == variation.y && lifeSegmentVariation != variation.type) {
                return;
            }
        }
        this.events.add(new Variation(lifeSegmentVariation, d, symbolContext));
        int n = lifeSegmentVariation.apply(this.stairs.getLastValue());
        this.stairs.addStep(d, n);
        assert (this.getLevel(d) == this.stairs.getValue(d));
        assert (n == this.stairs.getValue(d));
        assert (this.getLevel(d) == n);
        this.maxLevel = Math.max(this.getLevel(d), this.maxLevel);
    }

    public void finish(double d) {
        int n = this.getMissingClose();
        for (int i = 0; i < n; ++i) {
            this.addSegmentVariation(LifeSegmentVariation.SMALLER, d, null);
        }
    }

    int getMissingClose() {
        int n = 0;
        for (Variation variation : this.events) {
            if (variation.type == LifeSegmentVariation.LARGER) {
                ++n;
                continue;
            }
            --n;
        }
        return n;
    }

    int getLevel(double d) {
        return this.stairs.getValue(d);
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public double getRightShift(double d) {
        return this.getRightShiftAtLevel(this.getLevel(d));
    }

    public double getLeftShift(double d) {
        return this.getLeftShiftAtLevel(this.getLevel(d));
    }

    public double getMaxRightShift() {
        return this.getRightShiftAtLevel(this.getMaxLevel());
    }

    public double getMaxLeftShift() {
        return this.getLeftShiftAtLevel(this.getMaxLevel());
    }

    private double getRightShiftAtLevel(int n) {
        if (n == 0) {
            return 0.0;
        }
        return (double)n * (this.nominalPreferredWidth / 2.0);
    }

    private double getLeftShiftAtLevel(int n) {
        if (n == 0) {
            return 0.0;
        }
        return this.nominalPreferredWidth / 2.0;
    }

    private double getStartingX(StringBounder stringBounder) {
        double d = this.participant.getCenterX(stringBounder) - this.nominalPreferredWidth / 2.0;
        return d;
    }

    private SegmentColored getSegment(int n) {
        if (this.events.get(n).type != LifeSegmentVariation.LARGER) {
            return null;
        }
        int n2 = 1;
        for (int i = n + 1; i < this.events.size(); ++i) {
            n2 = this.events.get(i).type == LifeSegmentVariation.LARGER ? ++n2 : --n2;
            if (n2 != 0) continue;
            double d = this.events.get(n).y;
            double d2 = this.events.get(i).y;
            return new SegmentColored(d, d2, this.events.get(n).colors, this.shadowing);
        }
        return new SegmentColored(this.events.get(n).y, this.events.get(this.events.size() - 1).y, this.events.get(n).colors, this.shadowing);
    }

    private Collection<SegmentColored> getSegmentsCutted(StringBounder stringBounder, int n) {
        SegmentColored segmentColored = this.getSegment(n);
        if (segmentColored != null) {
            return segmentColored.cutSegmentIfNeed(this.participant.getDelays(stringBounder));
        }
        return Collections.emptyList();
    }

    public void drawU(UGraphic uGraphic, Skin skin, ISkinParam iSkinParam) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic = uGraphic.apply(new UTranslate(this.getStartingX(stringBounder), 0.0));
        for (int i = 0; i < this.events.size(); ++i) {
            ComponentType componentType = ComponentType.ALIVE_BOX_CLOSE_OPEN;
            Iterator<SegmentColored> iterator = this.getSegmentsCutted(stringBounder, i).iterator();
            while (iterator.hasNext()) {
                SegmentColored segmentColored = iterator.next();
                SkinParamDelegator skinParamDelegator = new SkinParamBackcolored(iSkinParam, segmentColored.getSpecificBackColor());
                HtmlColor htmlColor = segmentColored.getSpecificLineColor();
                if (htmlColor != null) {
                    skinParamDelegator = new SkinParamForceColor(skinParamDelegator, ColorParam.sequenceLifeLineBorder, htmlColor);
                }
                if (!iterator.hasNext()) {
                    componentType = componentType == ComponentType.ALIVE_BOX_CLOSE_OPEN ? ComponentType.ALIVE_BOX_CLOSE_CLOSE : ComponentType.ALIVE_BOX_OPEN_CLOSE;
                }
                Component component = skin.createComponent(componentType, null, skinParamDelegator, null);
                componentType = ComponentType.ALIVE_BOX_OPEN_OPEN;
                int n = this.getLevel(segmentColored.getPos1Initial());
                segmentColored.drawU(uGraphic, component, n);
            }
        }
    }

    public final void setCreate(double d) {
        this.create = d;
    }

    public final double getCreate() {
        return this.create;
    }

    public final double getDestroy() {
        return 0.0;
    }

    public final boolean shadowing() {
        return this.shadowing;
    }

    public SymbolContext getColors() {
        if (this.events.size() == 0) {
            return null;
        }
        return this.events.get(this.events.size() - 1).colors;
    }

    static class Variation {
        private final LifeSegmentVariation type;
        private final SymbolContext colors;
        private final double y;

        Variation(LifeSegmentVariation lifeSegmentVariation, double d, SymbolContext symbolContext) {
            this.type = lifeSegmentVariation;
            this.y = d;
            this.colors = symbolContext;
        }

        public String toString() {
            return (Object)((Object)this.type) + " " + this.y;
        }
    }
}

