/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.real.RealUtils;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Delay;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileWithCallbackY;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class DelayTile
implements Tile,
TileWithCallbackY {
    private final Delay delay;
    private final TileArguments tileArguments;
    private Real middle;
    private double y;

    public Event getEvent() {
        return this.delay;
    }

    public void callbackY(double d) {
        this.y = d;
    }

    public DelayTile(Delay delay, TileArguments tileArguments) {
        this.delay = delay;
        this.tileArguments = tileArguments;
    }

    private void init(StringBounder stringBounder) {
        if (this.middle != null) {
            return;
        }
        Real real = this.tileArguments.getFirstLivingSpace().getPosC(stringBounder);
        Component component = this.getComponent(stringBounder);
        Real real2 = this.tileArguments.getLastLivingSpace().getPosC(stringBounder);
        this.middle = RealUtils.middle(real, real2);
    }

    private Component getComponent(StringBounder stringBounder) {
        Component component = this.tileArguments.getSkin().createComponent(ComponentType.DELAY_TEXT, null, this.tileArguments.getSkinParam(), this.delay.getText());
        return component;
    }

    private double getPreferredWidth(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D.getWidth();
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        this.init(stringBounder);
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        Area area = new Area(this.getPreferredWidth(stringBounder), dimension2D.getHeight());
        this.tileArguments.getLivingSpaces().delayOn(this.y, dimension2D.getHeight());
        uGraphic = uGraphic.apply(new UTranslate(this.getMinX(stringBounder).getCurrentValue(), 0.0));
        component.drawU(uGraphic, area, (Context2D)((Object)uGraphic));
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D.getHeight();
    }

    public void addConstraints(StringBounder stringBounder) {
    }

    public Real getMinX(StringBounder stringBounder) {
        this.init(stringBounder);
        return this.middle.addFixed(-this.getPreferredWidth(stringBounder) / 2.0);
    }

    public Real getMaxX(StringBounder stringBounder) {
        this.init(stringBounder);
        return this.middle.addFixed(this.getPreferredWidth(stringBounder) / 2.0);
    }
}

