/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.MainTile;
import znaishaded.net.sourceforge.plantuml.skin.SimpleContext2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class MainTileAdapter
extends AbstractTextBlock
implements TextBlock {
    private final MainTile mainTile;
    private Dimension2D cacheDimension;

    public MainTileAdapter(MainTile mainTile) {
        if (mainTile == null) {
            throw new IllegalArgumentException();
        }
        this.mainTile = mainTile;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        if (this.cacheDimension == null) {
            double d = this.mainTile.getMaxX(stringBounder).getCurrentValue() - this.mainTile.getMinX(stringBounder).getCurrentValue();
            int n = this.mainTile.isShowFootbox() ? 2 : 1;
            double d2 = this.mainTile.getPreferredHeight(stringBounder) + (double)n * this.mainTile.getLivingSpaces().getHeadHeight(stringBounder);
            this.cacheDimension = new Dimension2DDouble(d, d2);
        }
        return this.cacheDimension;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        SimpleContext2D simpleContext2D = new SimpleContext2D(false);
        double d = this.mainTile.getPreferredHeight(stringBounder);
        LivingSpaces livingSpaces = this.mainTile.getLivingSpaces();
        double d2 = livingSpaces.getHeadHeight(stringBounder);
        this.mainTile.drawU(uGraphic.apply(new UTranslate(0.0, d2)));
        livingSpaces.drawLifeLines(uGraphic.apply(new UTranslate(0.0, d2)), d, simpleContext2D);
        livingSpaces.drawHeads(uGraphic, simpleContext2D, VerticalAlignment.BOTTOM);
        if (this.mainTile.isShowFootbox()) {
            livingSpaces.drawHeads(uGraphic.apply(new UTranslate(0.0, d + d2)), simpleContext2D, VerticalAlignment.TOP);
        }
        this.mainTile.drawForeground(uGraphic.apply(new UTranslate(0.0, d2)));
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.mainTile.getMinX(stringBounder);
    }
}

