/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.Iterator;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamBackcolored;
import znaishaded.net.sourceforge.plantuml.SkinParamBackcoloredReference;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Reference;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Bordered;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import znaishaded.net.sourceforge.plantuml.skin.Skin;

public class TileArguments
implements Bordered {
    private final StringBounder stringBounder;
    private final Real origin;
    private final LivingSpaces livingSpaces;
    private final Skin skin;
    private final ISkinParam skinParam;
    private Bordered bordered;

    public TileArguments(StringBounder stringBounder, LivingSpaces livingSpaces, Skin skin, ISkinParam iSkinParam, Real real) {
        this.stringBounder = stringBounder;
        this.origin = real;
        this.livingSpaces = livingSpaces;
        this.skin = skin;
        this.skinParam = iSkinParam;
    }

    public TileArguments withBackColorGeneral(HtmlColor htmlColor, HtmlColor htmlColor2) {
        return new TileArguments(this.stringBounder, this.livingSpaces, this.skin, new SkinParamBackcolored(this.skinParam, htmlColor, htmlColor2), this.origin);
    }

    public TileArguments withBackColor(Reference reference) {
        SkinParamBackcoloredReference skinParamBackcoloredReference = new SkinParamBackcoloredReference(this.skinParam, reference.getBackColorElement(), reference.getBackColorGeneral());
        return new TileArguments(this.stringBounder, this.livingSpaces, this.skin, skinParamBackcoloredReference, this.origin);
    }

    public final StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public final Real getOrigin() {
        return this.origin;
    }

    public final LivingSpaces getLivingSpaces() {
        return this.livingSpaces;
    }

    public final Skin getSkin() {
        return this.skin;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public LivingSpace getLivingSpace(Participant participant) {
        return this.livingSpaces.get(participant);
    }

    public LivingSpace getFirstLivingSpace() {
        return this.livingSpaces.values().iterator().next();
    }

    public LivingSpace getLastLivingSpace() {
        LivingSpace livingSpace = null;
        Iterator<LivingSpace> iterator = this.livingSpaces.values().iterator();
        while (iterator.hasNext()) {
            LivingSpace livingSpace2;
            livingSpace = livingSpace2 = iterator.next();
        }
        return livingSpace;
    }

    public void setBordered(Bordered bordered) {
        this.bordered = bordered;
    }

    public double getBorder1() {
        return this.bordered.getBorder1();
    }

    public double getBorder2() {
        return this.bordered.getBorder2();
    }
}

