/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.DotData;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockEmpty;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockWidth;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockWidthAdapter;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2InternalImage;
import znaishaded.net.sourceforge.plantuml.svek.DotDataImageBuilder;
import znaishaded.net.sourceforge.plantuml.svek.DotMode;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.InnerStateAutonom;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageState;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroupPngMakerState {
    private final CucaDiagram diagram;
    private final IGroup group;
    private final StringBounder stringBounder;
    private final Rose rose = new Rose();

    public GroupPngMakerState(CucaDiagram cucaDiagram, IGroup iGroup, StringBounder stringBounder) {
        this.diagram = cucaDiagram;
        this.stringBounder = stringBounder;
        this.group = iGroup;
        if (!iGroup.isGroup()) {
            throw new IllegalArgumentException();
        }
    }

    private List<Link> getPureInnerLinks() {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            if (!EntityUtils.isPureInnerLink12(this.group, link)) continue;
            arrayList.add(link);
        }
        return arrayList;
    }

    public IEntityImage getImage() {
        Display display = this.group.getDisplay();
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        TextBlock textBlock = display.create(new FontConfiguration(iSkinParam, FontParam.STATE, this.group.getStereotype()), HorizontalAlignment.CENTER, this.diagram.getSkinParam());
        if (this.group.size() == 0 && this.group.getChildren().size() == 0) {
            return new EntityImageState(this.group, this.diagram.getSkinParam());
        }
        List<Link> list = this.getPureInnerLinks();
        DotData dotData = new DotData(this.group, list, this.group.getLeafsDirect(), this.diagram.getUmlDiagramType(), iSkinParam, new InnerGroupHierarchy(), this.diagram.getColorMapper(), this.diagram.getEntityFactory(), this.diagram.isHideEmptyDescriptionForState(), DotMode.NORMAL, this.diagram.getNamespaceSeparator(), this.diagram.getPragma());
        DotDataImageBuilder dotDataImageBuilder = new DotDataImageBuilder(dotData, this.diagram.getEntityFactory(), this.diagram.getSource(), this.diagram.getPragma(), this.stringBounder);
        if (this.group.getGroupType() == GroupType.CONCURRENT_STATE) {
            return dotDataImageBuilder.buildImage(null, new String[0]);
        }
        if (this.group.getGroupType() != GroupType.STATE) {
            throw new UnsupportedOperationException(this.group.getGroupType().toString());
        }
        HtmlColor htmlColor = this.group.getColors(iSkinParam).getColor(ColorType.LINE);
        if (htmlColor == null) {
            htmlColor = this.getColor(ColorParam.stateBorder, this.group.getStereotype());
        }
        Stereotype stereotype = this.group.getStereotype();
        HtmlColor htmlColor2 = this.group.getColors(iSkinParam).getColor(ColorType.BACK) == null ? this.getColor(ColorParam.stateBackground, stereotype) : this.group.getColors(iSkinParam).getColor(ColorType.BACK);
        TextBlockWidth textBlockWidth = this.getAttributes(iSkinParam);
        Stereotype stereotype2 = this.group.getStereotype();
        boolean bl = stereotype2 != null && stereotype2.isWithOOSymbol();
        boolean bl2 = this.containsOnlyConcurrentStates(dotData);
        IEntityImage iEntityImage = bl2 ? this.buildImageForConcurrentState(dotData) : dotDataImageBuilder.buildImage(null, new String[0]);
        UStroke uStroke = this.group.getColors(iSkinParam).getSpecificLineStroke();
        if (uStroke == null) {
            uStroke = new UStroke(1.5);
        }
        return new InnerStateAutonom(iEntityImage, textBlock, textBlockWidth, htmlColor, htmlColor2, iSkinParam.shadowing(), this.group.getUrl99(), bl, uStroke);
    }

    private TextBlockWidth getAttributes(ISkinParam iSkinParam) {
        List<String> list = this.group.getBodier().getRawBody();
        if (list.size() == 0) {
            return new TextBlockEmpty();
        }
        FontConfiguration fontConfiguration = new FontConfiguration(iSkinParam, FontParam.STATE_ATTRIBUTE, null);
        Display display = list.size() == 1 ? Display.getWithNewlines(list.get(0)) : Display.create(list);
        TextBlock textBlock = display.create(fontConfiguration, HorizontalAlignment.LEFT, iSkinParam);
        return new TextBlockWidthAdapter(textBlock, 0.0);
    }

    private IEntityImage buildImageForConcurrentState(DotData dotData) {
        ArrayList<IEntityImage> arrayList = new ArrayList<IEntityImage>();
        for (ILeaf iLeaf : dotData.getLeafs()) {
            arrayList.add(iLeaf.getSvekImage());
        }
        return new CucaDiagramFileMakerSvek2InternalImage(arrayList, dotData.getTopParent().getConcurrentSeparator(), dotData.getSkinParam());
    }

    private boolean containsOnlyConcurrentStates(DotData dotData) {
        for (ILeaf iLeaf : dotData.getLeafs()) {
            if (!(iLeaf instanceof IGroup)) {
                return false;
            }
            if (((IGroup)((Object)iLeaf)).getLeafType() == LeafType.STATE_CONCURRENT) continue;
            return false;
        }
        return true;
    }

    private HtmlColor getColor(ColorParam colorParam, Stereotype stereotype) {
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return this.rose.getHtmlColor(iSkinParam, colorParam, stereotype);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InnerGroupHierarchy
    implements GroupHierarchy {
        InnerGroupHierarchy() {
        }

        @Override
        public Collection<IGroup> getChildrenGroups(IGroup iGroup) {
            if (EntityUtils.groupRoot(iGroup)) {
                return GroupPngMakerState.this.diagram.getChildrenGroups(GroupPngMakerState.this.group);
            }
            return GroupPngMakerState.this.diagram.getChildrenGroups(iGroup);
        }

        @Override
        public boolean isEmpty(IGroup iGroup) {
            return GroupPngMakerState.this.diagram.isEmpty(iGroup);
        }
    }
}

