/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvekUtils {
    private static final String pointsString = "points=\"";

    public static void traceString(File file, String string) throws IOException {
        PrintWriter printWriter = null;
        try {
            Log.info("Creating intermediate file " + file.getAbsolutePath());
            printWriter = new PrintWriter(new FileWriter(file));
            printWriter.print(string);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public static List<Point2D.Double> extractPointsList(String string, int n, double d) {
        int n2 = string.indexOf(pointsString, n);
        int n3 = string.indexOf("\"", n2 + pointsString.length());
        String string2 = string.substring(n2 + pointsString.length(), n3);
        List<Point2D.Double> list = SvekUtils.getPoints(string2, d);
        return list;
    }

    public static List<Point2D.Double> extractD(String string, int n, double d) {
        int n2 = string.indexOf("d=\"", n);
        int n3 = string.indexOf("\"", n2 + "d=\"".length());
        String string2 = string.substring(n2 + "d=\"".length(), n3);
        List<Point2D.Double> list = SvekUtils.getPoints(string2, d);
        return list;
    }

    public static int getIndexFromColor(String string, int n) {
        String string2 = "stroke=\"" + StringUtils.goLowerCase(StringUtils.getAsHtml(n)) + "\"";
        int n2 = string.indexOf(string2);
        if (n2 != -1) {
            return n2;
        }
        string2 = ";stroke:" + StringUtils.goLowerCase(StringUtils.getAsHtml(n)) + ";";
        n2 = string.indexOf(string2);
        if (n2 != -1) {
            return n2;
        }
        string2 = "fill=\"" + StringUtils.goLowerCase(StringUtils.getAsHtml(n)) + "\"";
        n2 = string.indexOf(string2);
        if (n2 != -1) {
            return n2;
        }
        return -1;
    }

    public static double getValue(String string, int n, String string2) {
        String string3 = string2 + "=\"";
        int n2 = string.indexOf(string3, n);
        if (n2 == -1) {
            throw new IllegalStateException();
        }
        int n3 = string.indexOf(34, n2 += string3.length());
        return Double.parseDouble(string.substring(n2, n3));
    }

    public static double getMaxX(List<Point2D.Double> list) {
        double d = list.get((int)0).x;
        for (int i = 1; i < list.size(); ++i) {
            if (!(list.get((int)i).x > d)) continue;
            d = list.get((int)i).x;
        }
        return d;
    }

    public static double getMinX(List<Point2D.Double> list) {
        double d = list.get((int)0).x;
        for (int i = 1; i < list.size(); ++i) {
            if (!(list.get((int)i).x < d)) continue;
            d = list.get((int)i).x;
        }
        return d;
    }

    public static Point2D.Double getMinXY(List<Point2D.Double> list) {
        return new Point2D.Double(SvekUtils.getMinX(list), SvekUtils.getMinY(list));
    }

    public static double getMaxY(List<Point2D.Double> list) {
        double d = list.get((int)0).y;
        for (int i = 1; i < list.size(); ++i) {
            if (!(list.get((int)i).y > d)) continue;
            d = list.get((int)i).y;
        }
        return d;
    }

    public static double getMinY(List<Point2D.Double> list) {
        double d = list.get((int)0).y;
        for (int i = 1; i < list.size(); ++i) {
            if (!(list.get((int)i).y < d)) continue;
            d = list.get((int)i).y;
        }
        return d;
    }

    private static List<Point2D.Double> getPoints(String string, double d) {
        try {
            ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " MC");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
                double d2 = Double.parseDouble(stringTokenizer2.nextToken());
                double d3 = Double.parseDouble(stringTokenizer2.nextToken()) + d;
                arrayList.add(new Point2D.Double(d2, d3));
            }
            return arrayList;
        }
        catch (NumberFormatException numberFormatException) {
            return Collections.emptyList();
        }
    }

    public static void println(StringBuilder stringBuilder) {
        stringBuilder.append('\n');
    }

    public static String pixelToInches(double d) {
        double d2 = d / 72.0;
        return String.format(Locale.US, "%6.6f", d2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PointListIterator
    implements Iterator<List<Point2D.Double>> {
        private final String text;
        private final double yDelta;
        private int pos = 0;

        public static PointListIterator create(String string, double d, int n) {
            PointListIterator pointListIterator = new PointListIterator(string, d);
            int n2 = SvekUtils.getIndexFromColor(string, n);
            if (n2 == -1) {
                pointListIterator.pos = -1;
            }
            return pointListIterator;
        }

        public PointListIterator cloneMe() {
            PointListIterator pointListIterator = new PointListIterator(this.text, this.yDelta);
            pointListIterator.pos = this.pos;
            return pointListIterator;
        }

        private PointListIterator(String string, double d) {
            this.text = string;
            this.yDelta = d;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public List<Point2D.Double> next() {
            if (this.pos == -1) {
                return Collections.emptyList();
            }
            try {
                List<Point2D.Double> list = SvekUtils.extractPointsList(this.text, this.pos, this.yDelta);
                this.pos = this.text.indexOf(SvekUtils.pointsString, this.pos) + SvekUtils.pointsString.length() + 1;
                return list;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                Log.error("Error " + stringIndexOutOfBoundsException);
                return Collections.emptyList();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

