/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Bibliotekon;
import znaishaded.net.sourceforge.plantuml.svek.Shape;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.Shadowable;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageActivity
extends AbstractEntityImage {
    public static final int CORNER = 25;
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final Url url;
    private final Bibliotekon bibliotekon;

    public EntityImageActivity(ILeaf iLeaf, ISkinParam iSkinParam, Bibliotekon bibliotekon) {
        super(iLeaf, iSkinParam);
        this.bibliotekon = bibliotekon;
        Stereotype stereotype = iLeaf.getStereotype();
        this.desc = iLeaf.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.ACTIVITY, stereotype), HorizontalAlignment.CENTER, iSkinParam);
        this.url = iLeaf.getUrl99();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.desc.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dimension2D, 20.0);
    }

    public final void drawU(UGraphic uGraphic) {
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        if (this.getShapeType() == ShapeType.ROUND_RECTANGLE) {
            uGraphic = this.drawNormal(uGraphic);
        } else if (this.getShapeType() == ShapeType.OCTAGON) {
            uGraphic = this.drawOctagon(uGraphic);
        } else {
            throw new UnsupportedOperationException();
        }
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    private UGraphic drawOctagon(UGraphic uGraphic) {
        Shape shape = this.bibliotekon.getShape(this.getEntity());
        Shadowable shadowable = shape.getOctagon();
        if (this.getSkinParam().shadowing()) {
            shadowable.setDeltaShadow(4.0);
        }
        uGraphic = this.applyColors(uGraphic);
        uGraphic.apply(new UStroke(1.5)).draw(shadowable);
        this.desc.drawU(uGraphic.apply(new UTranslate(10.0, 10.0)));
        return uGraphic;
    }

    private UGraphic drawNormal(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.calculateDimension(stringBounder);
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        URectangle uRectangle = new URectangle(d, d2, 25.0, 25.0);
        if (this.getSkinParam().shadowing()) {
            uRectangle.setDeltaShadow(4.0);
        }
        uGraphic = this.applyColors(uGraphic);
        uGraphic.apply(new UStroke(1.5)).draw(uRectangle);
        this.desc.drawU(uGraphic.apply(new UTranslate(10.0, 10.0)));
        return uGraphic;
    }

    private UGraphic applyColors(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.activityBorder, this.getStereo())));
        HtmlColor htmlColor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (htmlColor == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.activityBackground, this.getStereo());
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(htmlColor));
        return uGraphic;
    }

    public ShapeType getShapeType() {
        Stereotype stereotype = this.getStereo();
        if (this.getSkinParam().useOctagonForActivity(stereotype)) {
            return ShapeType.OCTAGON;
        }
        return ShapeType.ROUND_RECTANGLE;
    }
}

