/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.Direction;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.command.Position;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodyEnhanced2;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Bibliotekon;
import znaishaded.net.sourceforge.plantuml.svek.Shape;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageNote;
import znaishaded.net.sourceforge.plantuml.svek.image.Opale;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageTips
extends AbstractEntityImage {
    private final Rose rose = new Rose();
    private final ISkinParam skinParam;
    private final HtmlColor noteBackgroundColor;
    private final HtmlColor borderColor;
    private final Bibliotekon bibliotekon;
    private final double ySpacing = 10.0;

    public EntityImageTips(ILeaf iLeaf, ISkinParam iSkinParam, Bibliotekon bibliotekon) {
        super(iLeaf, EntityImageNote.getSkin(iSkinParam, iLeaf));
        this.skinParam = iSkinParam;
        this.bibliotekon = bibliotekon;
        this.noteBackgroundColor = iLeaf.getColors(iSkinParam).getColor(ColorType.BACK) == null ? this.rose.getHtmlColor(iSkinParam, ColorParam.noteBackground) : iLeaf.getColors(iSkinParam).getColor(ColorType.BACK);
        this.borderColor = this.rose.getHtmlColor(iSkinParam, ColorParam.noteBorder);
    }

    private Position getPosition() {
        if (this.getEntity().getCode().getFullName().endsWith(Position.RIGHT.name())) {
            return Position.RIGHT;
        }
        return Position.LEFT;
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = 0.0;
        double d2 = 0.0;
        for (Map.Entry<String, Display> entry : this.getEntity().getTips().entrySet()) {
            Display display = entry.getValue();
            Dimension2D dimension2D = this.getOpale(display).calculateDimension(stringBounder);
            d2 += dimension2D.getHeight();
            d2 += 10.0;
            d = Math.max(d, dimension2D.getWidth());
        }
        return new Dimension2DDouble(d, d2);
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        IEntity iEntity = this.bibliotekon.getOnlyOther(this.getEntity());
        Shape shape = this.bibliotekon.getShape(this.getEntity());
        Shape shape2 = this.bibliotekon.getShape(iEntity);
        Point2D point2D = shape.getPosition();
        Point2D point2D2 = shape2.getPosition();
        this.bibliotekon.getShape(this.getEntity());
        Position position = this.getPosition();
        Direction direction = position.reverseDirection();
        double d = 0.0;
        for (Map.Entry<String, Display> entry : this.getEntity().getTips().entrySet()) {
            Display display = entry.getValue();
            Rectangle2D rectangle2D = shape2.getImage().getInnerPosition(entry.getKey(), stringBounder, InnerStrategy.STRICT);
            if (rectangle2D == null) {
                return;
            }
            Opale opale = this.getOpale(display);
            Dimension2D dimension2D = opale.calculateDimension(stringBounder);
            Point2D.Double double_ = new Point2D.Double(0.0, dimension2D.getHeight() / 2.0);
            double d2 = point2D2.getX() - point2D.getX();
            if (direction == Direction.RIGHT && d2 < 0.0) {
                direction = direction.getInv();
            }
            d2 = direction == Direction.LEFT ? (d2 += rectangle2D.getMaxX()) : (d2 += 4.0);
            double d3 = point2D2.getY() - point2D.getY() - d + rectangle2D.getCenterY();
            Point2D.Double double_2 = new Point2D.Double(d2, d3);
            opale.setOpale(direction, double_, double_2);
            opale.drawU(uGraphic);
            uGraphic = uGraphic.apply(new UTranslate(0.0, dimension2D.getHeight() + 10.0));
            d += dimension2D.getHeight();
            d += 10.0;
        }
    }

    private Opale getOpale(Display display) {
        BodyEnhanced2 bodyEnhanced2 = new BodyEnhanced2(display, FontParam.NOTE, this.skinParam, HorizontalAlignment.LEFT, new FontConfiguration(this.skinParam, FontParam.NOTE, null));
        Opale opale = new Opale(this.borderColor, this.noteBackgroundColor, bodyEnhanced2, this.skinParam.shadowing(), true);
        return opale;
    }
}

