/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.syntax;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.BlockUml;
import znaishaded.net.sourceforge.plantuml.ErrorUml;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.LineLocationImpl;
import znaishaded.net.sourceforge.plantuml.OptionFlags;
import znaishaded.net.sourceforge.plantuml.PSystemError;
import znaishaded.net.sourceforge.plantuml.SourceStringReader;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.preproc.Defines;
import znaishaded.net.sourceforge.plantuml.syntax.SyntaxResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxChecker {
    public static SyntaxResult checkSyntax(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        return SyntaxChecker.checkSyntax(stringBuilder.toString());
    }

    public static SyntaxResult checkSyntax(String string) {
        OptionFlags.getInstance().setQuiet(true);
        SyntaxResult syntaxResult = new SyntaxResult();
        if (!string.startsWith("@startuml\n")) {
            syntaxResult.setError(true);
            syntaxResult.setLineLocation(new LineLocationImpl(null, null).oneLineRead());
            syntaxResult.addErrorText("No @startuml found");
            syntaxResult.setSuggest(Arrays.asList("Did you mean:", "@startuml"));
            return syntaxResult;
        }
        if (!string.endsWith("@enduml\n") && !string.endsWith("@enduml")) {
            syntaxResult.setError(true);
            syntaxResult.setLineLocation(SyntaxChecker.lastLineNumber2(string));
            syntaxResult.addErrorText("No @enduml found");
            syntaxResult.setSuggest(Arrays.asList("Did you mean:", "@enduml"));
            return syntaxResult;
        }
        SourceStringReader sourceStringReader = new SourceStringReader(Defines.createEmpty(), string, Collections.<String>emptyList());
        List<BlockUml> list = sourceStringReader.getBlocks();
        if (list.size() == 0) {
            syntaxResult.setError(true);
            syntaxResult.setLineLocation(SyntaxChecker.lastLineNumber2(string));
            syntaxResult.addErrorText("No @enduml found");
            syntaxResult.setSuggest(Arrays.asList("Did you mean:", "@enduml"));
            return syntaxResult;
        }
        Diagram diagram = list.get(0).getDiagram();
        syntaxResult.setCmapData(diagram.hasUrl());
        if (diagram instanceof UmlDiagram) {
            syntaxResult.setUmlDiagramType(((UmlDiagram)diagram).getUmlDiagramType());
            syntaxResult.setDescription(diagram.getDescription().getDescription());
        } else if (diagram instanceof PSystemError) {
            syntaxResult.setError(true);
            PSystemError pSystemError = (PSystemError)diagram;
            syntaxResult.setLineLocation(pSystemError.getLineLocation());
            syntaxResult.setSystemError(pSystemError);
            for (ErrorUml errorUml : pSystemError.getErrorsUml()) {
                syntaxResult.addErrorText(errorUml.getError());
            }
            syntaxResult.setSuggest(pSystemError.getSuggest());
        } else {
            syntaxResult.setDescription(diagram.getDescription().getDescription());
        }
        return syntaxResult;
    }

    public static SyntaxResult checkSyntaxFair(String string) {
        SyntaxResult syntaxResult = new SyntaxResult();
        SourceStringReader sourceStringReader = new SourceStringReader(Defines.createEmpty(), string, Collections.<String>emptyList());
        List<BlockUml> list = sourceStringReader.getBlocks();
        if (list.size() == 0) {
            syntaxResult.setError(true);
            syntaxResult.setLineLocation(SyntaxChecker.lastLineNumber2(string));
            syntaxResult.addErrorText("No @enduml found");
            syntaxResult.setSuggest(Arrays.asList("Did you mean:", "@enduml"));
            return syntaxResult;
        }
        Diagram diagram = list.get(0).getDiagram();
        syntaxResult.setCmapData(diagram.hasUrl());
        if (diagram instanceof UmlDiagram) {
            syntaxResult.setUmlDiagramType(((UmlDiagram)diagram).getUmlDiagramType());
            syntaxResult.setDescription(diagram.getDescription().getDescription());
        } else if (diagram instanceof PSystemError) {
            syntaxResult.setError(true);
            PSystemError pSystemError = (PSystemError)diagram;
            syntaxResult.setLineLocation(pSystemError.getLineLocation());
            for (ErrorUml errorUml : pSystemError.getErrorsUml()) {
                syntaxResult.addErrorText(errorUml.getError());
            }
            syntaxResult.setSystemError(pSystemError);
            syntaxResult.setSuggest(pSystemError.getSuggest());
        } else {
            syntaxResult.setDescription(diagram.getDescription().getDescription());
        }
        return syntaxResult;
    }

    private static int lastLineNumber(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n;
        }
        return n;
    }

    private static LineLocation lastLineNumber2(String string) {
        LineLocationImpl lineLocationImpl = new LineLocationImpl(null, null).oneLineRead();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            lineLocationImpl = lineLocationImpl.oneLineRead();
        }
        return lineLocationImpl;
    }
}

