/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.EmptyImageBuilder;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.eps.EpsStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.png.PngIO;
import znaishaded.net.sourceforge.plantuml.ugraphic.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import znaishaded.net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import znaishaded.net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;

public abstract class UGraphicUtils {
    public static void writeImage(OutputStream outputStream, String string, FileFormatOption fileFormatOption, long l, ColorMapper colorMapper, HtmlColor htmlColor, TextBlock textBlock) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.PNG) {
            BufferedImage bufferedImage = UGraphicUtils.createImage(colorMapper, htmlColor, textBlock);
            PngIO.write((RenderedImage)bufferedImage, outputStream, fileFormatOption.isWithMetadata() ? string : null, 96);
        } else if (fileFormat == FileFormat.SVG) {
            Dimension2D dimension2D = UGraphicUtils.computeSize(colorMapper, htmlColor, textBlock);
            UGraphicSvg uGraphicSvg = new UGraphicSvg(dimension2D, colorMapper, StringUtils.getAsHtml(colorMapper.getMappedColor(htmlColor)), false, 1.0, fileFormatOption.getSvgLinkTarget(), fileFormatOption.getHoverColor(), l);
            textBlock.drawU(uGraphicSvg);
            uGraphicSvg.createXml(outputStream, fileFormatOption.isWithMetadata() ? string : null);
        } else if (fileFormat == FileFormat.EPS) {
            UGraphicEps uGraphicEps = new UGraphicEps(colorMapper, EpsStrategy.getDefault2());
            textBlock.drawU(uGraphicEps);
            outputStream.write(uGraphicEps.getEPSCode().getBytes());
        } else if (fileFormat == FileFormat.EPS_TEXT) {
            UGraphicEps uGraphicEps = new UGraphicEps(colorMapper, EpsStrategy.WITH_MACRO_AND_TEXT);
            textBlock.drawU(uGraphicEps);
            outputStream.write(uGraphicEps.getEPSCode().getBytes());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static BufferedImage createImage(ColorMapper colorMapper, HtmlColor htmlColor, TextBlock textBlock) {
        Dimension2D dimension2D = UGraphicUtils.computeSize(colorMapper, htmlColor, textBlock);
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(dimension2D.getWidth(), dimension2D.getHeight(), colorMapper.getMappedColor(htmlColor));
        BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
        Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
        UGraphicG2d uGraphicG2d = new UGraphicG2d(colorMapper, graphics2D, 1.0);
        textBlock.drawU(uGraphicG2d);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static Dimension2D computeSize(ColorMapper colorMapper, HtmlColor htmlColor, TextBlock textBlock) {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, colorMapper.getMappedColor(htmlColor));
        Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
        UGraphicG2d uGraphicG2d = new UGraphicG2d(colorMapper, graphics2D, 1.0);
        Dimension2D dimension2D = textBlock.calculateDimension(uGraphicG2d.getStringBounder());
        graphics2D.dispose();
        return dimension2D;
    }
}

