/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.html5;

import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.eps.EpsGraphics;

public class Html5Drawer {
    private int maxX = 10;
    private int maxY = 10;
    private String strokeStyle = "black";
    private String fillStyle = "black";
    private List<String> data = new ArrayList<String>();

    protected final void ensureVisible(double d, double d2) {
        if (d > (double)this.maxX) {
            this.maxX = (int)(d + 1.0);
        }
        if (d2 > (double)this.maxY) {
            this.maxY = (int)(d2 + 1.0);
        }
    }

    private static String format(double d) {
        return EpsGraphics.format(d);
    }

    public final void setStrokeColor(String string) {
        this.strokeStyle = string;
    }

    public final void setFillColor(String string) {
        this.fillStyle = string;
    }

    public String generateHtmlCode() {
        StringBuilder stringBuilder = new StringBuilder();
        this.ap(stringBuilder, "<html>");
        this.ap(stringBuilder, "<canvas id=\"demo\" width=\"700\" height=\"350\">");
        this.ap(stringBuilder, "</canvas>");
        this.ap(stringBuilder, "</html>");
        this.ap(stringBuilder, "<script>");
        this.ap(stringBuilder, "window.addEventListener('load', function () {");
        this.ap(stringBuilder, "var elem = document.getElementById('demo');");
        this.ap(stringBuilder, "if (!elem || !elem.getContext) { return;}");
        this.ap(stringBuilder, "var ctx = elem.getContext('2d');");
        this.ap(stringBuilder, "if (!ctx) { return;}");
        for (String string : this.data) {
            this.ap(stringBuilder, string);
        }
        this.ap(stringBuilder, "}, false);");
        this.ap(stringBuilder, "</script>");
        this.ap(stringBuilder, "</html>");
        return stringBuilder.toString();
    }

    private void ap(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string);
        stringBuilder.append('\n');
    }

    public void htmlRectangle(double d, double d2, double d3, double d4, double d5, double d6) {
        this.ensureVisible(d, d2);
        this.ensureVisible(d + d3, d2 + d4);
        this.data.add("//RECT");
        this.data.add("ctx.strokeStyle='" + this.strokeStyle + "';");
        this.data.add("ctx.fillStyle='" + this.fillStyle + "';");
        this.data.add("ctx.rect(" + Html5Drawer.format(d) + "," + Html5Drawer.format(d2) + "," + Html5Drawer.format(d3) + "," + Html5Drawer.format(d4) + ");");
        this.data.add("ctx.fill();");
        this.data.add("ctx.stroke();");
    }

    public void htmlLine(double d, double d2, double d3, double d4, double d5) {
        this.ensureVisible(d + 2.0 * d5, d2 + 2.0 * d5);
        this.ensureVisible(d3 + 2.0 * d5, d4 + 2.0 * d5);
        this.data.add("ctx.strokeStyle='" + this.strokeStyle + "';");
        this.data.add("ctx.beginPath();");
        this.data.add("ctx.moveTo(" + Html5Drawer.format(d) + "," + Html5Drawer.format(d2) + ");");
        this.data.add("ctx.lineTo(" + Html5Drawer.format(d3) + "," + Html5Drawer.format(d4) + ");");
        this.data.add("ctx.stroke();");
        this.data.add("ctx.closePath();");
    }
}

