/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.svg;

import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.PathIterator;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.svg.SvgGraphics;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.UClip;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.UText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverTextAsPathSvg
implements UDriver<SvgGraphics> {
    private final FontRenderContext fontRenderContext;
    private final ClipContainer clipContainer;

    public DriverTextAsPathSvg(FontRenderContext fontRenderContext, ClipContainer clipContainer) {
        this.fontRenderContext = fontRenderContext;
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, SvgGraphics svgGraphics) {
        UClip uClip = this.clipContainer.getClip();
        if (uClip != null && !uClip.isInside(d, d2)) {
            return;
        }
        UText uText = (UText)uShape;
        FontConfiguration fontConfiguration = uText.getFontConfiguration();
        UFont uFont = fontConfiguration.getFont();
        TextLayout textLayout = new TextLayout(uText.getText(), uFont.getFont(), this.fontRenderContext);
        DriverTextAsPathSvg.drawPathIterator(svgGraphics, d, d2, textLayout.getOutline(null).getPathIterator(null));
    }

    static void drawPathIterator(SvgGraphics svgGraphics, double d, double d2, PathIterator pathIterator) {
        svgGraphics.newpath();
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            if (n == 0) {
                svgGraphics.moveto(dArray[0] + d, dArray[1] + d2);
            } else if (n == 1) {
                svgGraphics.lineto(dArray[0] + d, dArray[1] + d2);
            } else if (n == 4) {
                svgGraphics.closepath();
            } else if (n == 3) {
                svgGraphics.curveto(dArray[0] + d, dArray[1] + d2, dArray[2] + d, dArray[3] + d2, dArray[4] + d, dArray[5] + d2);
            } else if (n == 2) {
                svgGraphics.quadto(dArray[0] + d, dArray[1] + d2, dArray[2] + d, dArray[3] + d2);
            } else {
                throw new UnsupportedOperationException("code=" + n);
            }
            pathIterator.next();
        }
        svgGraphics.fill(pathIterator.getWindingRule());
    }
}

