/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.xmi;

import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import znaishaded.net.sourceforge.plantuml.classdiagram.ClassDiagram;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LongCode;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Member;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.skin.VisibilityModifier;
import znaishaded.net.sourceforge.plantuml.utils.UniqueSequence;
import znaishaded.net.sourceforge.plantuml.xmi.CucaDiagramXmiMaker;
import znaishaded.net.sourceforge.plantuml.xmi.IXmiClassDiagram;

abstract class XmiClassDiagramAbstract
implements IXmiClassDiagram {
    protected final ClassDiagram classDiagram;
    protected final Document document;
    protected Element ownedElement;
    protected final Set<IEntity> done = new HashSet<IEntity>();

    public XmiClassDiagramAbstract(ClassDiagram classDiagram) throws ParserConfigurationException {
        this.classDiagram = classDiagram;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.newDocument();
        this.document.setXmlVersion("1.0");
        this.document.setXmlStandalone(true);
        Element element = this.document.createElement("XMI");
        element.setAttribute("xmi.version", "1.1");
        element.setAttribute("xmlns:UML", "href://org.omg/UML/1.3");
        this.document.appendChild(element);
        Element element2 = this.document.createElement("XMI.header");
        element.appendChild(element2);
        Element element3 = this.document.createElement("XMI.metamodel");
        element3.setAttribute("xmi.name", "UML");
        element3.setAttribute("xmi.version", "1.3");
        element2.appendChild(element3);
        Element element4 = this.document.createElement("XMI.content");
        element.appendChild(element4);
        Element element5 = this.document.createElement("UML:Model");
        element5.setAttribute("xmi.id", CucaDiagramXmiMaker.getModel(classDiagram));
        element5.setAttribute("name", "PlantUML");
        element4.appendChild(element5);
        this.ownedElement = this.document.createElement("UML:Namespace.ownedElement");
        element5.appendChild(this.ownedElement);
    }

    protected final String forXMI(String string) {
        return string.replace(':', ' ');
    }

    protected final String forXMI(Display display) {
        if (Display.isNull(display)) {
            return "";
        }
        return display.get(0).toString().replace(':', ' ');
    }

    public final void transformerXml(OutputStream outputStream) throws TransformerException, ParserConfigurationException {
        DOMSource dOMSource = new DOMSource(this.document);
        StreamResult streamResult = new StreamResult(outputStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(dOMSource, streamResult);
    }

    protected final Element createEntityNode(IEntity iEntity) {
        VisibilityModifier visibilityModifier;
        Element element;
        Object object;
        Element element2 = this.document.createElement("UML:Class");
        if (iEntity.getLeafType() == LeafType.NOTE) {
            return null;
        }
        element2.setAttribute("xmi.id", iEntity.getUid());
        element2.setAttribute("name", iEntity.getDisplay().get(0).toString());
        LongCode longCode = iEntity.getParentContainer().getLongCode();
        if (longCode == null) {
            element2.setAttribute("namespace", CucaDiagramXmiMaker.getModel(this.classDiagram));
        } else {
            element2.setAttribute("namespace", longCode.getFullName());
        }
        Stereotype stereotype = iEntity.getStereotype();
        if (stereotype != null) {
            object = this.document.createElement("UML:ModelElement.stereotype");
            for (String iterator : stereotype.getMultipleLabels()) {
                Element element3 = this.document.createElement("UML:Stereotype");
                element3.setAttribute("name", iterator);
                object.appendChild(element3);
            }
            element2.appendChild((Node)object);
        }
        if ((object = iEntity.getLeafType()) == LeafType.ABSTRACT_CLASS) {
            element2.setAttribute("isAbstract", "true");
        } else if (object == LeafType.INTERFACE) {
            element2.setAttribute("isInterface", "true");
        }
        Element element3 = this.document.createElement("UML:Classifier.feature");
        element2.appendChild(element3);
        for (Member member : iEntity.getBodier().getFieldsToDisplay()) {
            element = this.document.createElement("UML:Attribute");
            element.setAttribute("xmi.id", "att" + UniqueSequence.getValue());
            element.setAttribute("name", member.getDisplay(false));
            visibilityModifier = member.getVisibilityModifier();
            if (visibilityModifier != null) {
                element.setAttribute("visibility", visibilityModifier.getXmiVisibility());
            }
            element3.appendChild(element);
        }
        for (Member member : iEntity.getBodier().getMethodsToDisplay()) {
            element = this.document.createElement("UML:Operation");
            element.setAttribute("xmi.id", "att" + UniqueSequence.getValue());
            element.setAttribute("name", member.getDisplay(false));
            visibilityModifier = member.getVisibilityModifier();
            if (visibilityModifier != null) {
                element.setAttribute("visibility", visibilityModifier.getXmiVisibility());
            }
            element3.appendChild(element);
        }
        return element2;
    }
}

