/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.commons.csv;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import znaishaded.org.apache.commons.csv.Assertions;
import znaishaded.org.apache.commons.csv.CSVFormat;

public final class CSVPrinter
implements Flushable,
Closeable {
    private final Appendable out;
    private final CSVFormat format;
    private boolean newRecord = true;

    public CSVPrinter(Appendable out, CSVFormat format) throws IOException {
        Assertions.notNull(out, "out");
        Assertions.notNull(format, "format");
        this.out = out;
        this.format = format;
        if (format.getHeaderComments() != null) {
            for (String line : format.getHeaderComments()) {
                if (line == null) continue;
                this.printComment(line);
            }
        }
        if (format.getHeader() != null && !format.getSkipHeaderRecord()) {
            this.printRecord(format.getHeader());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out instanceof Closeable) {
            ((Closeable)((Object)this.out)).close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out instanceof Flushable) {
            ((Flushable)((Object)this.out)).flush();
        }
    }

    public Appendable getOut() {
        return this.out;
    }

    public void print(Object value) throws IOException {
        this.format.print(value, this.out, this.newRecord);
        this.newRecord = false;
    }

    public void printComment(String comment) throws IOException {
        if (!this.format.isCommentMarkerSet()) {
            return;
        }
        if (!this.newRecord) {
            this.println();
        }
        this.out.append(this.format.getCommentMarker().charValue());
        this.out.append(' ');
        block4: for (int i = 0; i < comment.length(); ++i) {
            char c = comment.charAt(i);
            switch (c) {
                case '\r': {
                    if (i + 1 < comment.length() && comment.charAt(i + 1) == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    this.println();
                    this.out.append(this.format.getCommentMarker().charValue());
                    this.out.append(' ');
                    continue block4;
                }
                default: {
                    this.out.append(c);
                }
            }
        }
        this.println();
    }

    public void println() throws IOException {
        this.format.println(this.out);
        this.newRecord = true;
    }

    public void printRecord(Iterable<?> values) throws IOException {
        for (Object value : values) {
            this.print(value);
        }
        this.println();
    }

    public void printRecord(Object ... values) throws IOException {
        this.format.printRecord(this.out, values);
        this.newRecord = true;
    }

    public void printRecords(Iterable<?> values) throws IOException {
        for (Object value : values) {
            if (value instanceof Object[]) {
                this.printRecord((Object[])value);
                continue;
            }
            if (value instanceof Iterable) {
                this.printRecord((Iterable)value);
                continue;
            }
            this.printRecord(value);
        }
    }

    public void printRecords(Object ... values) throws IOException {
        for (Object value : values) {
            if (value instanceof Object[]) {
                this.printRecord((Object[])value);
                continue;
            }
            if (value instanceof Iterable) {
                this.printRecord((Iterable)value);
                continue;
            }
            this.printRecord(value);
        }
    }

    public void printRecords(ResultSet resultSet) throws SQLException, IOException {
        int columnCount = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            for (int i = 1; i <= columnCount; ++i) {
                this.print(resultSet.getObject(i));
            }
            this.println();
        }
    }
}

