/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.internal;

import java.util.regex.Pattern;
import znaishaded.org.commonmark.internal.BlockContent;
import znaishaded.org.commonmark.node.Block;
import znaishaded.org.commonmark.node.HtmlBlock;
import znaishaded.org.commonmark.node.Paragraph;
import znaishaded.org.commonmark.parser.block.AbstractBlockParser;
import znaishaded.org.commonmark.parser.block.AbstractBlockParserFactory;
import znaishaded.org.commonmark.parser.block.BlockContinue;
import znaishaded.org.commonmark.parser.block.BlockStart;
import znaishaded.org.commonmark.parser.block.MatchedBlockParser;
import znaishaded.org.commonmark.parser.block.ParserState;

public class HtmlBlockParser
extends AbstractBlockParser {
    private static final Pattern[][] BLOCK_PATTERNS = new Pattern[][]{{null, null}, {Pattern.compile("^<(?:script|pre|style)(?:\\s|>|$)", 2), Pattern.compile("</(?:script|pre|style)>", 2)}, {Pattern.compile("^<!--"), Pattern.compile("-->")}, {Pattern.compile("^<[?]"), Pattern.compile("\\?>")}, {Pattern.compile("^<![A-Z]"), Pattern.compile(">")}, {Pattern.compile("^<!\\[CDATA\\["), Pattern.compile("\\]\\]>")}, {Pattern.compile("^</?(?:address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option|p|param|section|source|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul)(?:\\s|[/]?[>]|$)", 2), null}, {Pattern.compile("^(?:<[A-Za-z][A-Za-z0-9-]*(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)*\\s*/?>|</[A-Za-z][A-Za-z0-9-]*\\s*[>])\\s*$", 2), null}};
    private final HtmlBlock block = new HtmlBlock();
    private final Pattern closingPattern;
    private boolean finished = false;
    private BlockContent content = new BlockContent();

    private HtmlBlockParser(Pattern closingPattern) {
        this.closingPattern = closingPattern;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (this.finished) {
            return BlockContinue.none();
        }
        if (state.isBlank() && this.closingPattern == null) {
            return BlockContinue.none();
        }
        return BlockContinue.atIndex(state.getIndex());
    }

    @Override
    public void addLine(CharSequence line) {
        this.content.add(line);
        if (this.closingPattern != null && this.closingPattern.matcher(line).find()) {
            this.finished = true;
        }
    }

    @Override
    public void closeBlock() {
        this.block.setLiteral(this.content.getString());
        this.content = null;
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int nextNonSpace = state.getNextNonSpaceIndex();
            CharSequence line = state.getLine();
            if (state.getIndent() < 4 && line.charAt(nextNonSpace) == '<') {
                for (int blockType = 1; blockType <= 7; ++blockType) {
                    if (blockType == 7 && matchedBlockParser.getMatchedBlockParser().getBlock() instanceof Paragraph) continue;
                    Pattern opener = BLOCK_PATTERNS[blockType][0];
                    Pattern closer = BLOCK_PATTERNS[blockType][1];
                    boolean matches = opener.matcher(line.subSequence(nextNonSpace, line.length())).find();
                    if (!matches) continue;
                    return BlockStart.of(new HtmlBlockParser(closer)).atIndex(state.getIndex());
                }
            }
            return BlockStart.none();
        }
    }
}

