/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.internal.util;

public class Parsing {
    private static final String TAGNAME = "[A-Za-z][A-Za-z0-9-]*";
    private static final String ATTRIBUTENAME = "[a-zA-Z_:][a-zA-Z0-9:._-]*";
    private static final String UNQUOTEDVALUE = "[^\"'=<>`\\x00-\\x20]+";
    private static final String SINGLEQUOTEDVALUE = "'[^']*'";
    private static final String DOUBLEQUOTEDVALUE = "\"[^\"]*\"";
    private static final String ATTRIBUTEVALUE = "(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\")";
    private static final String ATTRIBUTEVALUESPEC = "(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))";
    private static final String ATTRIBUTE = "(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)";
    public static final String OPENTAG = "<[A-Za-z][A-Za-z0-9-]*(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)*\\s*/?>";
    public static final String CLOSETAG = "</[A-Za-z][A-Za-z0-9-]*\\s*[>]";
    public static int CODE_BLOCK_INDENT = 4;

    public static int columnsToNextTabStop(int column) {
        return 4 - column % 4;
    }

    public static int findLineBreak(CharSequence s2, int startIndex) {
        for (int i = startIndex; i < s2.length(); ++i) {
            switch (s2.charAt(i)) {
                case '\n': 
                case '\r': {
                    return i;
                }
            }
        }
        return -1;
    }

    public static boolean isBlank(CharSequence s2) {
        return Parsing.findNonSpace(s2, 0) == -1;
    }

    public static boolean isLetter(CharSequence s2, int index) {
        int codePoint = Character.codePointAt(s2, index);
        return Character.isLetter(codePoint);
    }

    public static boolean isSpaceOrTab(CharSequence s2, int index) {
        if (index < s2.length()) {
            switch (s2.charAt(index)) {
                case '\t': 
                case ' ': {
                    return true;
                }
            }
        }
        return false;
    }

    public static CharSequence prepareLine(CharSequence line) {
        StringBuilder sb = null;
        block3: for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (line.charAt(i)) {
                case '\u0000': {
                    if (sb == null) {
                        sb = new StringBuilder(line.length());
                        sb.append(line, 0, i);
                    }
                    sb.append('\ufffd');
                    continue block3;
                }
                default: {
                    if (sb == null) continue block3;
                    sb.append(c);
                }
            }
        }
        if (sb != null) {
            return sb.toString();
        }
        return line;
    }

    private static int findNonSpace(CharSequence s2, int startIndex) {
        block3: for (int i = startIndex; i < s2.length(); ++i) {
            switch (s2.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i;
                }
            }
        }
        return -1;
    }
}

