/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.table;

import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.table.CsvTableParser;
import org.testingisdocumenting.znai.parser.table.JsonTableParser;
import org.testingisdocumenting.znai.parser.table.MapBasedMarkupTableMapping;
import org.testingisdocumenting.znai.parser.table.MarkupTableData;
import org.testingisdocumenting.znai.parser.table.MarkupTableDataMapping;
import org.testingisdocumenting.znai.resources.ResourcesResolver;

class TableDocElementFromParams {
    private final PluginParams pluginParams;
    private final MarkupParser parser;
    private final Path fullPath;
    private final Path mappingPath;
    private final MarkupTableDataMapping tableDataMapping;
    private final String mappingFileName;
    private MarkupTableData rearrangedTable;
    private final ResourcesResolver resourcesResolver;
    private final String content;

    TableDocElementFromParams(PluginParams pluginParams, MarkupParser parser, ResourcesResolver resourcesResolver, Path fullPath, String content) {
        this.pluginParams = pluginParams;
        this.parser = parser;
        this.resourcesResolver = resourcesResolver;
        this.content = content;
        this.fullPath = fullPath;
        this.mappingFileName = pluginParams.getOpts().get("mappingPath", "");
        this.mappingPath = this.mappingFileName.isEmpty() ? null : resourcesResolver.fullPath(this.mappingFileName);
        this.tableDataMapping = this.createMapping();
    }

    MarkupTableData getRearrangedTable() {
        return this.rearrangedTable;
    }

    Stream<AuxiliaryFile> mappingAuxiliaryFile() {
        return this.mappingPath == null ? Stream.empty() : Stream.of(AuxiliaryFile.builtTime(this.mappingPath));
    }

    private MarkupTableDataMapping createMapping() {
        return new MapBasedMarkupTableMapping(this.mappingPath == null ? Collections.emptyMap() : this.createMappingFromFileContent());
    }

    private Map<Object, Object> createMappingFromFileContent() {
        MarkupTableData tableData = CsvTableParser.parseWithHeader(this.resourcesResolver.textContent(this.mappingFileName), "from", "to");
        return Collections.unmodifiableMap(tableData.toKeyValue());
    }

    PluginResult create() {
        MarkupTableData tableFromContent = (this.isJson() ? JsonTableParser.parse(this.content) : CsvTableParser.parse(this.content)).mapValues(this.tableDataMapping);
        this.rearrangedTable = this.pluginParams.getOpts().has("columns") ? tableFromContent.withColumnsInOrder(this.pluginParams.getOpts().getList("columns")) : tableFromContent;
        Map<String, Object> tableAsMap = this.rearrangedTable.toMap();
        List columns = (List)tableAsMap.get("columns");
        this.pluginParams.getOpts().forEach((columnName, meta) -> {
            Optional<Map> column = columns.stream().filter(c -> c.get("title").equals(columnName)).findFirst();
            column.ifPresent(c -> c.putAll((Map)meta));
        });
        tableAsMap.put("data", this.parseMarkupInEachRow((List)tableAsMap.get("data")));
        LinkedHashMap<String, Map<String, Object>> props = new LinkedHashMap<String, Map<String, Object>>();
        props.put("table", tableAsMap);
        if (this.pluginParams.getOpts().has("title")) {
            props.put("title", (Map<String, Object>)this.pluginParams.getOpts().get("title"));
        }
        return PluginResult.docElement("Table", props);
    }

    private List<Object> parseMarkupInEachRow(List<List<Object>> rows) {
        return rows.stream().map(this::parseMarkupInCell).collect(Collectors.toList());
    }

    private List<Object> parseMarkupInCell(List<Object> row) {
        return row.stream().map(this::parseMarkupInCell).collect(Collectors.toList());
    }

    private List<Object> parseMarkupInCell(Object cell) {
        if (cell == null) {
            return Collections.emptyList();
        }
        MarkupParserResult parserResult = this.parser.parse(this.fullPath, cell.toString());
        return (List)parserResult.getDocElement().toMap().get("content");
    }

    private boolean isJson() {
        return this.content.trim().startsWith("[");
    }
}

