/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server.sockets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.console.ansi.FontStyle;
import org.testingisdocumenting.znai.server.sockets.WebSocketHandler;
import org.testingisdocumenting.znai.utils.JsonUtils;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.http.ServerWebSocket;

public abstract class JsonWebSocketHandler
implements WebSocketHandler {
    private final List<SocketWithUrl> sockets = new ArrayList<SocketWithUrl>();
    private final String name;
    private final String url;
    protected Vertx vertx;

    public JsonWebSocketHandler(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public abstract void onConnect(String var1);

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public void init(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public boolean handles(ServerWebSocket ws) {
        return ws.uri().startsWith(this.url);
    }

    @Override
    public void handle(ServerWebSocket ws) {
        if (!this.handles(ws)) {
            return;
        }
        this.sockets.add(new SocketWithUrl(ws, ws.uri()));
        ConsoleOutputs.out(new Object[]{this.name + " connected: ", Color.BLUE, ws.path()});
        this.renderNumberOfSockets();
        this.onConnect(ws.uri());
        ws.handler(data -> {
            String dataString = data.getString(0, data.length());
            System.out.println(dataString);
        });
        ws.closeHandler(h2 -> {
            this.sockets.removeIf(s2 -> ((SocketWithUrl)s2).socket == ws);
            ConsoleOutputs.out(new Object[]{Color.RED, this.name + " connection closed"});
            this.renderNumberOfSockets();
        });
    }

    public void send(String subUrlToContain, Map<String, ?> payload) {
        if (this.sockets.isEmpty()) {
            ConsoleOutputs.out(new Object[]{Color.BLUE, this.name + " connection ", FontStyle.NORMAL, "with", Color.BLUE, " web page ", FontStyle.NORMAL, "is not established. ", Color.BLUE, "reload or open", FontStyle.NORMAL, " the page"});
            return;
        }
        String text = JsonUtils.serialize(payload);
        ConsoleOutputs.out(new Object[]{this.name + " sending: ", Color.BLUE, text});
        this.sockets.stream().filter(s2 -> ((SocketWithUrl)s2).connectedUrl.contains(subUrlToContain)).forEach(s2 -> ((SocketWithUrl)s2).socket.writeFinalTextFrame(text));
    }

    private void renderNumberOfSockets() {
        ConsoleOutputs.out("there are " + this.sockets.size() + " opened sockets for " + this.name);
    }

    private static class SocketWithUrl {
        private final ServerWebSocket socket;
        private final String connectedUrl;

        public SocketWithUrl(ServerWebSocket socket, String connectedUrl) {
            this.socket = socket;
            this.connectedUrl = connectedUrl;
        }
    }
}

