/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.website;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.parser.MarkupParsingConfiguration;
import org.testingisdocumenting.znai.structure.DocMeta;
import org.testingisdocumenting.znai.structure.DocStructure;
import org.testingisdocumenting.znai.structure.DocUrl;
import org.testingisdocumenting.znai.structure.TableOfContents;
import org.testingisdocumenting.znai.structure.TocItem;
import org.testingisdocumenting.znai.website.ProgressReporter;

class WebSiteDocStructure
implements DocStructure {
    private final ComponentsRegistry componentsRegistry;
    private final DocMeta docMeta;
    private TableOfContents toc;
    private final MarkupParsingConfiguration parsingConfiguration;
    private final List<LinkToValidate> linksToValidate;
    private final Map<String, Path> globalAnchorPathById;
    private final Map<TocItem, List<String>> localAnchorIdsByTocItem;

    WebSiteDocStructure(ComponentsRegistry componentsRegistry, DocMeta docMeta, TableOfContents toc, MarkupParsingConfiguration parsingConfiguration) {
        this.componentsRegistry = componentsRegistry;
        this.docMeta = docMeta;
        this.toc = toc;
        this.parsingConfiguration = parsingConfiguration;
        this.linksToValidate = new ArrayList<LinkToValidate>();
        this.globalAnchorPathById = new HashMap<String, Path>();
        this.localAnchorIdsByTocItem = new HashMap<TocItem, List<String>>();
    }

    void removeGlobalAnchorsForPath(Path path) {
        List<Map.Entry> entriesForPath = this.globalAnchorPathById.entrySet().stream().filter(kv -> ((Path)kv.getValue()).equals(path)).collect(Collectors.toList());
        entriesForPath.forEach(kv -> this.globalAnchorPathById.remove(kv.getKey()));
    }

    void removeLocalAnchorsForTocItem(TocItem tocItem) {
        this.localAnchorIdsByTocItem.remove(tocItem);
    }

    void removeLinksForPath(Path path) {
        this.linksToValidate.removeIf(linkToValidate -> ((LinkToValidate)linkToValidate).path.equals(path));
    }

    void updateToc(TableOfContents toc) {
        this.toc = toc;
    }

    public void validateCollectedLinks() {
        String validationErrorMessage = this.linksToValidate.stream().map(this::validateLink).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("\n\n"));
        if (!validationErrorMessage.isEmpty()) {
            throw new IllegalArgumentException(validationErrorMessage + "\n");
        }
    }

    @Override
    public void validateUrl(Path path, String additionalClue, DocUrl docUrl) {
        if (docUrl.isExternalUrl()) {
            return;
        }
        this.linksToValidate.add(new LinkToValidate(path, additionalClue, docUrl));
    }

    @Override
    public String createUrl(Path path, DocUrl docUrl) {
        if (docUrl.isExternalUrl()) {
            return docUrl.getUrl();
        }
        if (docUrl.isIndexUrl()) {
            return "/" + this.docMeta.getId() + (docUrl.getAnchorId().isEmpty() ? "" : docUrl.getAnchorIdWithHash());
        }
        return this.fullUrl(this.createUrlBase(path, docUrl) + docUrl.getAnchorIdWithHash());
    }

    @Override
    public String fullUrl(String relativeUrl) {
        return "/" + this.docMeta.getId() + "/" + relativeUrl;
    }

    @Override
    public void registerGlobalAnchor(Path sourcePath, String anchorId) {
        Path existingPath = this.globalAnchorPathById.get(anchorId);
        if (existingPath != null) {
            ProgressReporter.reportWarning("global anchor <" + anchorId + "> specified in " + sourcePath + " is already registered in " + existingPath);
        }
        this.globalAnchorPathById.put(anchorId, sourcePath);
    }

    @Override
    public void registerLocalAnchor(Path path, String anchorId) {
        TocItem tocItem = this.parsingConfiguration.tocItemByPath(this.componentsRegistry, this.toc, path);
        if (tocItem == null) {
            throw new RuntimeException("Can't find TocItem associated with path: " + path);
        }
        List anchors = this.localAnchorIdsByTocItem.computeIfAbsent(tocItem, k -> new ArrayList());
        anchors.add(anchorId);
    }

    @Override
    public String globalAnchorUrl(Path clientPath, String anchorId) {
        Path anchorPath = this.globalAnchorPathById.get(anchorId);
        if (anchorPath == null) {
            throw new RuntimeException("cannot find global anchor <" + anchorId + "> referenced in " + clientPath);
        }
        TocItem tocItem = this.parsingConfiguration.tocItemByPath(this.componentsRegistry, this.toc, anchorPath);
        return this.createUrl(anchorPath, new DocUrl(tocItem.getDirName(), tocItem.getFileNameWithoutExtension(), anchorId));
    }

    @Override
    public TableOfContents tableOfContents() {
        return this.toc;
    }

    private Optional<String> validateLink(LinkToValidate link) {
        String anchorId = link.docUrl.getAnchorId();
        TocItem tocItem = this.findTocItemByLink(link);
        if (tocItem == null) {
            return Optional.of(this.createInvalidLinkMessage(link));
        }
        if (anchorId.isEmpty()) {
            return Optional.empty();
        }
        if (this.isValidGlobalAnchor(tocItem, anchorId)) {
            return Optional.empty();
        }
        if (this.isValidLocalAnchor(tocItem, anchorId)) {
            return Optional.empty();
        }
        return Optional.of(this.createInvalidLinkMessage(link));
    }

    private TocItem findTocItemByLink(LinkToValidate link) {
        if (link.docUrl.isIndexUrl()) {
            return this.toc.getIndex();
        }
        return link.docUrl.isAnchorOnly() ? this.parsingConfiguration.tocItemByPath(this.componentsRegistry, this.toc, link.path) : this.toc.findTocItem(link.docUrl.getDirName(), link.docUrl.getFileName());
    }

    private String createInvalidLinkMessage(LinkToValidate link) {
        String checkFileMessage = "\ncheck file: " + link.path + (link.additionalClue.isEmpty() ? "" : ", " + link.additionalClue);
        if (link.docUrl.isAnchorOnly()) {
            return "can't find the anchor " + link.docUrl.getAnchorIdWithHash() + checkFileMessage;
        }
        String url = link.docUrl.getDirName() + "/" + link.docUrl.getFileName() + link.docUrl.getAnchorIdWithHash();
        return "can't find a page associated with: " + url + checkFileMessage;
    }

    private boolean isValidGlobalAnchor(TocItem tocItemWithAnchor, String anchorId) {
        Path anchorPath = this.globalAnchorPathById.get(anchorId);
        if (anchorPath == null) {
            return false;
        }
        TocItem anchorTocItem = this.parsingConfiguration.tocItemByPath(this.componentsRegistry, this.toc, anchorPath);
        return tocItemWithAnchor.equals(anchorTocItem);
    }

    private boolean isValidLocalAnchor(TocItem tocItem, String anchorId) {
        List<String> localIds = this.localAnchorIdsByTocItem.get(tocItem);
        return localIds != null && localIds.contains(anchorId);
    }

    private String createUrlBase(Path path, DocUrl docUrl) {
        if (docUrl.isAnchorOnly()) {
            TocItem tocItem = this.parsingConfiguration.tocItemByPath(this.componentsRegistry, this.toc, path);
            return tocItem == null ? "<should not happen>" : tocItem.getDirName() + "/" + tocItem.getFileNameWithoutExtension();
        }
        return docUrl.getDirName() + "/" + docUrl.getFileName();
    }

    private static class LinkToValidate {
        private final Path path;
        private final String additionalClue;
        private final DocUrl docUrl;

        LinkToValidate(Path path, String additionalClue, DocUrl docUrl) {
            this.path = path;
            this.additionalClue = additionalClue;
            this.docUrl = docUrl;
        }
    }
}

