/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole.command;

import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.creole.legacy.StripeSimple;
import znaishaded.net.sourceforge.plantuml.math.ScientificEquationSafe;

public class CommandCreoleLatex
implements Command {
    private final Pattern2 pattern;

    private CommandCreoleLatex(String p) {
        this.pattern = MyPattern.cmpile(p);
    }

    public static Command create() {
        return new CommandCreoleLatex("^(?i)(\\<latex\\>(.+?)\\</latex\\>)");
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m3 = this.pattern.matcher(line);
        if (!m3.find()) {
            return 0;
        }
        return m3.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m3 = this.pattern.matcher(line);
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        String latex = m3.group(2);
        stripe.addMath(ScientificEquationSafe.fromLatex(latex));
        return line.substring(m3.group(1).length());
    }
}

