/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram.dot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.svek.GroupPngMakerActivity;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;

public final class CucaDiagramSimplifierActivity {
    private final CucaDiagram diagram;
    private final StringBounder stringBounder;

    public CucaDiagramSimplifierActivity(CucaDiagram diagram, List<String> dotStrings, StringBounder stringBounder) throws IOException, InterruptedException {
        boolean changed;
        this.diagram = diagram;
        this.stringBounder = stringBounder;
        do {
            changed = false;
            ArrayList<IGroup> groups = new ArrayList<IGroup>(diagram.getGroups(false));
            for (IGroup g2 : groups) {
                if (!diagram.isAutarkic(g2)) continue;
                IEntityImage img = this.computeImage(g2);
                g2.overrideImage(img, LeafType.ACTIVITY);
                changed = true;
            }
        } while (changed);
    }

    private IEntityImage computeImage(IGroup g2) throws IOException, InterruptedException {
        GroupPngMakerActivity maker = new GroupPngMakerActivity(this.diagram, g2, this.stringBounder);
        return maker.getImage();
    }
}

