/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.ImgValign;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.AffineTransformType;
import znaishaded.net.sourceforge.plantuml.ugraphic.PixelImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class TileImage
extends AbstractTextBlock
implements TextBlock {
    private final BufferedImage image;
    private final int vspace;

    public TileImage(BufferedImage image, ImgValign valign, int vspace) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        this.image = image;
        this.vspace = vspace;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.image.getWidth(), this.image.getHeight() + 2 * this.vspace);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(UTranslate.dy(this.vspace)).draw(new UImage(new PixelImage(this.image, AffineTransformType.TYPE_BILINEAR)));
    }
}

